@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The machine extension instance view.
 * @property name The machine extension name.
 * @property status Instance view status.
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 */
public data class MachineExtensionPropertiesResponseInstanceView(
    public val name: String,
    public val status: MachineExtensionInstanceViewResponseStatus? = null,
    public val type: String,
    public val typeHandlerVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.MachineExtensionPropertiesResponseInstanceView):
            MachineExtensionPropertiesResponseInstanceView =
            MachineExtensionPropertiesResponseInstanceView(
                name = javaType.name(),
                status = javaType.status().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.MachineExtensionInstanceViewResponseStatus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
                typeHandlerVersion = javaType.typeHandlerVersion(),
            )
    }
}
