@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Software Assurance properties of the cluster.
 * @property lastUpdated TimeStamp denoting the latest SA benefit applicability is validated.
 * @property softwareAssuranceIntent Customer Intent for Software Assurance Benefit.
 * @property softwareAssuranceStatus Status of the Software Assurance for the cluster.
 */
public data class SoftwareAssurancePropertiesResponse(
    public val lastUpdated: String,
    public val softwareAssuranceIntent: String? = null,
    public val softwareAssuranceStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.SoftwareAssurancePropertiesResponse):
            SoftwareAssurancePropertiesResponse = SoftwareAssurancePropertiesResponse(
            lastUpdated = javaType.lastUpdated(),
            softwareAssuranceIntent = javaType.softwareAssuranceIntent().map({ args0 -> args0 }).orElse(null),
            softwareAssuranceStatus = javaType.softwareAssuranceStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
