@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VHD to attach as OS disk
 * @property id Resource ID of the OS disk
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 */
public data class VirtualMachineInstancePropertiesResponseOsDisk(
    public val id: String? = null,
    public val osType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachineInstancePropertiesResponseOsDisk):
            VirtualMachineInstancePropertiesResponseOsDisk =
            VirtualMachineInstancePropertiesResponseOsDisk(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
