@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * LinuxConfiguration - linux specific configuration values for the virtual machine
 * @property disablePasswordAuthentication DisablePasswordAuthentication - whether password authentication should be disabled
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
 * @property ssh SSH - contains settings related to ssh configuration
 */
public data class VirtualMachinePropertiesResponseLinuxConfiguration(
    public val disablePasswordAuthentication: Boolean? = null,
    public val provisionVMAgent: Boolean? = null,
    public val ssh: VirtualMachinePropertiesResponseSsh? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.VirtualMachinePropertiesResponseLinuxConfiguration):
            VirtualMachinePropertiesResponseLinuxConfiguration =
            VirtualMachinePropertiesResponseLinuxConfiguration(
                disablePasswordAuthentication = javaType.disablePasswordAuthentication().map({ args0 ->
                    args0
                }).orElse(null),
                provisionVMAgent = javaType.provisionVMAgent().map({ args0 -> args0 }).orElse(null),
                ssh = javaType.ssh().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseSsh.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
