@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin

import com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs.builder
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs.StoragePropertiesArgs
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs.StoragePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
 * Azure REST API version: 2023-04-06.
 * Other available API versions: 2023-08-04-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Put a new AzureBareMetalStorageInstance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureBareMetalStorageInstance = new AzureNative.BareMetalInfrastructure.AzureBareMetalStorageInstance("azureBareMetalStorageInstance", new()
 *     {
 *         AzureBareMetalStorageInstanceName = "myAzureBareMetalStorageInstance",
 *         AzureBareMetalStorageInstanceUniqueIdentifier = "23415635-4d7e-41dc-9598-8194f22c24e9",
 *         Location = "westus2",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProperties = new AzureNative.BareMetalInfrastructure.Inputs.StoragePropertiesArgs
 *         {
 *             Generation = "Gen4",
 *             HardwareType = "NetApp",
 *             OfferingType = "EPIC",
 *             ProvisioningState = "Succeeded",
 *             StorageBillingProperties = new AzureNative.BareMetalInfrastructure.Inputs.StorageBillingPropertiesArgs
 *             {
 *                 AzureBareMetalStorageInstanceSize = "",
 *                 BillingMode = "PAYG",
 *             },
 *             StorageType = "FC",
 *             WorkloadType = "ODB",
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/baremetalinfrastructure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := baremetalinfrastructure.NewAzureBareMetalStorageInstance(ctx, "azureBareMetalStorageInstance", &baremetalinfrastructure.AzureBareMetalStorageInstanceArgs{
 * 			AzureBareMetalStorageInstanceName:             pulumi.String("myAzureBareMetalStorageInstance"),
 * 			AzureBareMetalStorageInstanceUniqueIdentifier: pulumi.String("23415635-4d7e-41dc-9598-8194f22c24e9"),
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProperties: baremetalinfrastructure.StoragePropertiesResponse{
 * 				Generation:        pulumi.String("Gen4"),
 * 				HardwareType:      pulumi.String("NetApp"),
 * 				OfferingType:      pulumi.String("EPIC"),
 * 				ProvisioningState: pulumi.String("Succeeded"),
 * 				StorageBillingProperties: &baremetalinfrastructure.StorageBillingPropertiesArgs{
 * 					AzureBareMetalStorageInstanceSize: pulumi.String(""),
 * 					BillingMode:                       pulumi.String("PAYG"),
 * 				},
 * 				StorageType:  pulumi.String("FC"),
 * 				WorkloadType: pulumi.String("ODB"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstance;
 * import com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureBareMetalStorageInstance = new AzureBareMetalStorageInstance("azureBareMetalStorageInstance", AzureBareMetalStorageInstanceArgs.builder()
 *             .azureBareMetalStorageInstanceName("myAzureBareMetalStorageInstance")
 *             .azureBareMetalStorageInstanceUniqueIdentifier("23415635-4d7e-41dc-9598-8194f22c24e9")
 *             .location("westus2")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProperties(Map.ofEntries(
 *                 Map.entry("generation", "Gen4"),
 *                 Map.entry("hardwareType", "NetApp"),
 *                 Map.entry("offeringType", "EPIC"),
 *                 Map.entry("provisioningState", "Succeeded"),
 *                 Map.entry("storageBillingProperties", Map.ofEntries(
 *                     Map.entry("azureBareMetalStorageInstanceSize", ""),
 *                     Map.entry("billingMode", "PAYG")
 *                 )),
 *                 Map.entry("storageType", "FC"),
 *                 Map.entry("workloadType", "ODB")
 *             ))
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:baremetalinfrastructure:AzureBareMetalStorageInstance myAzureBareMetalStorageInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BareMetalInfrastructure/bareMetalStorageInstances/{azureBareMetalStorageInstanceName}
 * ```
 * @property azureBareMetalStorageInstanceName Name of the AzureBareMetalStorage on Azure instance.
 * @property azureBareMetalStorageInstanceUniqueIdentifier Specifies the AzureBareMetaStorageInstance unique ID.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageProperties Specifies the storage properties for the AzureBareMetalStorage instance.
 * @property tags Resource tags.
 */
public data class AzureBareMetalStorageInstanceArgs(
    public val azureBareMetalStorageInstanceName: Output<String>? = null,
    public val azureBareMetalStorageInstanceUniqueIdentifier: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageProperties: Output<StoragePropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs> {
    override fun toJava():
        com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs =
        com.pulumi.azurenative.baremetalinfrastructure.AzureBareMetalStorageInstanceArgs.builder()
            .azureBareMetalStorageInstanceName(
                azureBareMetalStorageInstanceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .azureBareMetalStorageInstanceUniqueIdentifier(
                azureBareMetalStorageInstanceUniqueIdentifier?.applyValue({ args0 ->
                    args0
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageProperties(storageProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureBareMetalStorageInstanceArgs].
 */
@PulumiTagMarker
public class AzureBareMetalStorageInstanceArgsBuilder internal constructor() {
    private var azureBareMetalStorageInstanceName: Output<String>? = null

    private var azureBareMetalStorageInstanceUniqueIdentifier: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageProperties: Output<StoragePropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the AzureBareMetalStorage on Azure instance.
     */
    @JvmName("smieqnmfoffvoptb")
    public suspend fun azureBareMetalStorageInstanceName(`value`: Output<String>) {
        this.azureBareMetalStorageInstanceName = value
    }

    /**
     * @param value Specifies the AzureBareMetaStorageInstance unique ID.
     */
    @JvmName("wegqnhupvysoivss")
    public suspend fun azureBareMetalStorageInstanceUniqueIdentifier(`value`: Output<String>) {
        this.azureBareMetalStorageInstanceUniqueIdentifier = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iuprmnweyauuoywa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qyioswrdpqjcdwdb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the storage properties for the AzureBareMetalStorage instance.
     */
    @JvmName("gjakcwavewpndcuw")
    public suspend fun storageProperties(`value`: Output<StoragePropertiesArgs>) {
        this.storageProperties = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mnrgqjyslfwtgded")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the AzureBareMetalStorage on Azure instance.
     */
    @JvmName("amdxhmrchcmuvkuv")
    public suspend fun azureBareMetalStorageInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBareMetalStorageInstanceName = mapped
    }

    /**
     * @param value Specifies the AzureBareMetaStorageInstance unique ID.
     */
    @JvmName("adhgxqvrvsoroijw")
    public suspend fun azureBareMetalStorageInstanceUniqueIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBareMetalStorageInstanceUniqueIdentifier = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bvsgfsiorvybqlvf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("asgxnaacvcqrsceu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the storage properties for the AzureBareMetalStorage instance.
     */
    @JvmName("oqsvukceyqbqtttt")
    public suspend fun storageProperties(`value`: StoragePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProperties = mapped
    }

    /**
     * @param argument Specifies the storage properties for the AzureBareMetalStorage instance.
     */
    @JvmName("ukdhnapwjhyhfmvk")
    public suspend fun storageProperties(argument: suspend StoragePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StoragePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProperties = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dvotsxgtlwjxntvc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("btdtvrirlyclqcyi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureBareMetalStorageInstanceArgs = AzureBareMetalStorageInstanceArgs(
        azureBareMetalStorageInstanceName = azureBareMetalStorageInstanceName,
        azureBareMetalStorageInstanceUniqueIdentifier = azureBareMetalStorageInstanceUniqueIdentifier,
        location = location,
        resourceGroupName = resourceGroupName,
        storageProperties = storageProperties,
        tags = tags,
    )
}
