@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin

import com.pulumi.azurenative.baremetalinfrastructure.BaremetalinfrastructureFunctions.getAzureBareMetalStorageInstancePlain
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs.GetAzureBareMetalStorageInstancePlainArgs
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs.GetAzureBareMetalStorageInstancePlainArgsBuilder
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.GetAzureBareMetalStorageInstanceResult
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.GetAzureBareMetalStorageInstanceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object BaremetalinfrastructureFunctions {
    /**
     * Gets an Azure BareMetal Storage instance for the specified subscription, resource group, and instance name.
     * Azure REST API version: 2023-04-06.
     * Other available API versions: 2023-08-04-preview, 2023-11-01-preview.
     * @param argument null
     * @return AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
     */
    public suspend
    fun getAzureBareMetalStorageInstance(argument: GetAzureBareMetalStorageInstancePlainArgs):
        GetAzureBareMetalStorageInstanceResult =
        toKotlin(getAzureBareMetalStorageInstancePlain(argument.toJava()).await())

    /**
     * @see [getAzureBareMetalStorageInstance].
     * @param azureBareMetalStorageInstanceName Name of the AzureBareMetalStorage on Azure instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
     */
    public suspend fun getAzureBareMetalStorageInstance(
        azureBareMetalStorageInstanceName: String,
        resourceGroupName: String,
    ): GetAzureBareMetalStorageInstanceResult {
        val argument = GetAzureBareMetalStorageInstancePlainArgs(
            azureBareMetalStorageInstanceName = azureBareMetalStorageInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getAzureBareMetalStorageInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureBareMetalStorageInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;baremetalinfrastructure&#46;kotlin&#46;inputs&#46;GetAzureBareMetalStorageInstancePlainArgs].
     * @return AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
     */
    public suspend
    fun getAzureBareMetalStorageInstance(argument: suspend GetAzureBareMetalStorageInstancePlainArgsBuilder.() -> Unit):
        GetAzureBareMetalStorageInstanceResult {
        val builder = GetAzureBareMetalStorageInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAzureBareMetalStorageInstancePlain(builtArgument.toJava()).await())
    }
}
