@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.inputs

import com.pulumi.azurenative.baremetalinfrastructure.inputs.StoragePropertiesArgs.builder
import com.pulumi.azurenative.baremetalinfrastructure.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * described the storage properties of the azure baremetalstorage instance
 * @property generation the kind of storage instance
 * @property hardwareType the hardware type of the storage instance
 * @property offeringType the offering type for which the resource is getting provisioned
 * @property provisioningState State of provisioning of the AzureBareMetalStorageInstance
 * @property storageBillingProperties the billing related information for the resource
 * @property storageType the storage protocol for which the resource is getting provisioned
 * @property workloadType the workload for which the resource is getting provisioned
 */
public data class StoragePropertiesArgs(
    public val generation: Output<String>? = null,
    public val hardwareType: Output<String>? = null,
    public val offeringType: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val storageBillingProperties: Output<StorageBillingPropertiesArgs>? = null,
    public val storageType: Output<String>? = null,
    public val workloadType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.baremetalinfrastructure.inputs.StoragePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.baremetalinfrastructure.inputs.StoragePropertiesArgs =
        com.pulumi.azurenative.baremetalinfrastructure.inputs.StoragePropertiesArgs.builder()
            .generation(generation?.applyValue({ args0 -> args0 }))
            .hardwareType(hardwareType?.applyValue({ args0 -> args0 }))
            .offeringType(offeringType?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storageBillingProperties(
                storageBillingProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .workloadType(workloadType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoragePropertiesArgs].
 */
@PulumiTagMarker
public class StoragePropertiesArgsBuilder internal constructor() {
    private var generation: Output<String>? = null

    private var hardwareType: Output<String>? = null

    private var offeringType: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var storageBillingProperties: Output<StorageBillingPropertiesArgs>? = null

    private var storageType: Output<String>? = null

    private var workloadType: Output<String>? = null

    /**
     * @param value the kind of storage instance
     */
    @JvmName("cqjqxfgitvuhrlxd")
    public suspend fun generation(`value`: Output<String>) {
        this.generation = value
    }

    /**
     * @param value the hardware type of the storage instance
     */
    @JvmName("yluluvlyfqdhkmih")
    public suspend fun hardwareType(`value`: Output<String>) {
        this.hardwareType = value
    }

    /**
     * @param value the offering type for which the resource is getting provisioned
     */
    @JvmName("qxuujmxgsohbeaxj")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value State of provisioning of the AzureBareMetalStorageInstance
     */
    @JvmName("ivyxqlahuyhgofjq")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value the billing related information for the resource
     */
    @JvmName("fymrehipxjbfycku")
    public suspend fun storageBillingProperties(`value`: Output<StorageBillingPropertiesArgs>) {
        this.storageBillingProperties = value
    }

    /**
     * @param value the storage protocol for which the resource is getting provisioned
     */
    @JvmName("ddvbcemuwwwriwwg")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value the workload for which the resource is getting provisioned
     */
    @JvmName("olmyvkxqvrxojxsy")
    public suspend fun workloadType(`value`: Output<String>) {
        this.workloadType = value
    }

    /**
     * @param value the kind of storage instance
     */
    @JvmName("eftpwsroahwcqycl")
    public suspend fun generation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value the hardware type of the storage instance
     */
    @JvmName("bafdvfoethtqtqxm")
    public suspend fun hardwareType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareType = mapped
    }

    /**
     * @param value the offering type for which the resource is getting provisioned
     */
    @JvmName("gukkmsttsydhwuwa")
    public suspend fun offeringType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value State of provisioning of the AzureBareMetalStorageInstance
     */
    @JvmName("lnjitnphrthnwxds")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value State of provisioning of the AzureBareMetalStorageInstance
     */
    @JvmName("jlvrshrkanmkdlum")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value State of provisioning of the AzureBareMetalStorageInstance
     */
    @JvmName("ngvqpbuiwtwjxdfl")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value the billing related information for the resource
     */
    @JvmName("mbhvvyihocxqfinn")
    public suspend fun storageBillingProperties(`value`: StorageBillingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageBillingProperties = mapped
    }

    /**
     * @param argument the billing related information for the resource
     */
    @JvmName("swkrjntboxbsssdk")
    public suspend
    fun storageBillingProperties(argument: suspend StorageBillingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageBillingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageBillingProperties = mapped
    }

    /**
     * @param value the storage protocol for which the resource is getting provisioned
     */
    @JvmName("vrgcrclskuntdisf")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value the workload for which the resource is getting provisioned
     */
    @JvmName("uwyvautfgfkjflgu")
    public suspend fun workloadType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadType = mapped
    }

    internal fun build(): StoragePropertiesArgs = StoragePropertiesArgs(
        generation = generation,
        hardwareType = hardwareType,
        offeringType = offeringType,
        provisioningState = provisioningState,
        storageBillingProperties = storageBillingProperties,
        storageType = storageType,
        workloadType = workloadType,
    )
}
