@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * AzureBareMetalStorageInstance info on Azure (ARM properties and AzureBareMetalStorage properties)
 * @property azureBareMetalStorageInstanceUniqueIdentifier Specifies the AzureBareMetaStorageInstance unique ID.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property storageProperties Specifies the storage properties for the AzureBareMetalStorage instance.
 * @property systemData The system metadata relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAzureBareMetalStorageInstanceResult(
    public val azureBareMetalStorageInstanceUniqueIdentifier: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val storageProperties: StoragePropertiesResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.baremetalinfrastructure.outputs.GetAzureBareMetalStorageInstanceResult):
            GetAzureBareMetalStorageInstanceResult = GetAzureBareMetalStorageInstanceResult(
            azureBareMetalStorageInstanceUniqueIdentifier = javaType.azureBareMetalStorageInstanceUniqueIdentifier().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            storageProperties = javaType.storageProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.StoragePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
