@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.baremetalinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the billing related details of the AzureBareMetalStorageInstance.
 * @property azureBareMetalStorageInstanceSize the SKU type that is provisioned
 * @property billingMode the billing mode for the storage instance
 */
public data class StorageBillingPropertiesResponse(
    public val azureBareMetalStorageInstanceSize: String? = null,
    public val billingMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.baremetalinfrastructure.outputs.StorageBillingPropertiesResponse):
            StorageBillingPropertiesResponse = StorageBillingPropertiesResponse(
            azureBareMetalStorageInstanceSize = javaType.azureBareMetalStorageInstanceSize().map({ args0 ->
                args0
            }).orElse(null),
            billingMode = javaType.billingMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
