@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
 */
public enum class DiffDiskPlacement(
    public val javaValue: com.pulumi.azurenative.batch.enums.DiffDiskPlacement,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.DiffDiskPlacement> {
    /**
     * The Ephemeral OS Disk is stored on the VM cache.
     */
    CacheDisk(com.pulumi.azurenative.batch.enums.DiffDiskPlacement.CacheDisk),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.DiffDiskPlacement = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.DiffDiskPlacement):
            DiffDiskPlacement = DiffDiskPlacement.values().first { it.javaValue == javaType }
    }
}
