@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If omitted, no disks on the compute nodes in the pool will be encrypted.
 */
public enum class DiskEncryptionTarget(
    public val javaValue: com.pulumi.azurenative.batch.enums.DiskEncryptionTarget,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.DiskEncryptionTarget> {
    /**
     * The OS Disk on the compute node is encrypted.
     */
    OsDisk(com.pulumi.azurenative.batch.enums.DiskEncryptionTarget.OsDisk),

    /**
     * The temporary disk on the compute node is encrypted. On Linux this encryption applies to other partitions (such as those on mounted data disks) when encryption occurs at boot time.
     */
    TemporaryDisk(com.pulumi.azurenative.batch.enums.DiskEncryptionTarget.TemporaryDisk),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.DiskEncryptionTarget = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.DiskEncryptionTarget):
            DiskEncryptionTarget = DiskEncryptionTarget.values().first { it.javaValue == javaType }
    }
}
