@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
 */
public enum class LoginMode(
    public val javaValue: com.pulumi.azurenative.batch.enums.LoginMode,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.LoginMode> {
    /**
     * The LOGON32_LOGON_BATCH Win32 login mode. The batch login mode is recommended for long running parallel processes.
     */
    Batch(com.pulumi.azurenative.batch.enums.LoginMode.Batch),

    /**
     * The LOGON32_LOGON_INTERACTIVE Win32 login mode. Some applications require having permissions associated with the interactive login mode. If this is the case for an application used in your task, then this option is recommended.
     */
    Interactive(com.pulumi.azurenative.batch.enums.LoginMode.Interactive),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.LoginMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.LoginMode): LoginMode =
            LoginMode.values().first { it.javaValue == javaType }
    }
}
