@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService.
 */
public enum class PoolAllocationMode(
    public val javaValue: com.pulumi.azurenative.batch.enums.PoolAllocationMode,
) : ConvertibleToJava<com.pulumi.azurenative.batch.enums.PoolAllocationMode> {
    /**
     * Pools will be allocated in subscriptions owned by the Batch service.
     */
    BatchService(com.pulumi.azurenative.batch.enums.PoolAllocationMode.BatchService),

    /**
     * Pools will be allocated in a subscription owned by the user.
     */
    UserSubscription(com.pulumi.azurenative.batch.enums.PoolAllocationMode.UserSubscription),
    ;

    override fun toJava(): com.pulumi.azurenative.batch.enums.PoolAllocationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.enums.PoolAllocationMode):
            PoolAllocationMode = PoolAllocationMode.values().first { it.javaValue == javaType }
    }
}
