@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.AutoUserSpecificationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.AutoUserScope
import com.pulumi.azurenative.batch.kotlin.enums.ElevationLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property elevationLevel The default value is nonAdmin.
 * @property scope The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
 */
public data class AutoUserSpecificationArgs(
    public val elevationLevel: Output<ElevationLevel>? = null,
    public val scope: Output<AutoUserScope>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.AutoUserSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.AutoUserSpecificationArgs =
        com.pulumi.azurenative.batch.inputs.AutoUserSpecificationArgs.builder()
            .elevationLevel(elevationLevel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AutoUserSpecificationArgs].
 */
@PulumiTagMarker
public class AutoUserSpecificationArgsBuilder internal constructor() {
    private var elevationLevel: Output<ElevationLevel>? = null

    private var scope: Output<AutoUserScope>? = null

    /**
     * @param value The default value is nonAdmin.
     */
    @JvmName("wvobgwpvdeunssnm")
    public suspend fun elevationLevel(`value`: Output<ElevationLevel>) {
        this.elevationLevel = value
    }

    /**
     * @param value The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
     */
    @JvmName("vfhsxveatanolmlt")
    public suspend fun scope(`value`: Output<AutoUserScope>) {
        this.scope = value
    }

    /**
     * @param value The default value is nonAdmin.
     */
    @JvmName("ljkqnjidtbbqshto")
    public suspend fun elevationLevel(`value`: ElevationLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elevationLevel = mapped
    }

    /**
     * @param value The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
     */
    @JvmName("fgfetdyimrljkhtx")
    public suspend fun scope(`value`: AutoUserScope?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): AutoUserSpecificationArgs = AutoUserSpecificationArgs(
        elevationLevel = elevationLevel,
        scope = scope,
    )
}
