@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.AzureFileShareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountKey
 * @property accountName
 * @property azureFileUrl This is of the form 'https://{account}.file.core.windows.net/'.
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 */
public data class AzureFileShareConfigurationArgs(
    public val accountKey: Output<String>,
    public val accountName: Output<String>,
    public val azureFileUrl: Output<String>,
    public val mountOptions: Output<String>? = null,
    public val relativeMountPath: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.AzureFileShareConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.AzureFileShareConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.AzureFileShareConfigurationArgs.builder()
            .accountKey(accountKey.applyValue({ args0 -> args0 }))
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .azureFileUrl(azureFileUrl.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0 }))
            .relativeMountPath(relativeMountPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileShareConfigurationArgs].
 */
@PulumiTagMarker
public class AzureFileShareConfigurationArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var azureFileUrl: Output<String>? = null

    private var mountOptions: Output<String>? = null

    private var relativeMountPath: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("awafdytgnrtnlwwv")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value
     */
    @JvmName("pmfcdoomnkwwfreg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value This is of the form 'https://{account}.file.core.windows.net/'.
     */
    @JvmName("keecbkgiiebmsucg")
    public suspend fun azureFileUrl(`value`: Output<String>) {
        this.azureFileUrl = value
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("ajslttenfnllqhtj")
    public suspend fun mountOptions(`value`: Output<String>) {
        this.mountOptions = value
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("odbgbikorjhhwnny")
    public suspend fun relativeMountPath(`value`: Output<String>) {
        this.relativeMountPath = value
    }

    /**
     * @param value
     */
    @JvmName("iqvxloyjuxacvydv")
    public suspend fun accountKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("jmywthfseeeecxfh")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value This is of the form 'https://{account}.file.core.windows.net/'.
     */
    @JvmName("qksjrnekjsqkkfpm")
    public suspend fun azureFileUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureFileUrl = mapped
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("vsnxtrnkrlxtlpvh")
    public suspend fun mountOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("trpaqtufibyorpap")
    public suspend fun relativeMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativeMountPath = mapped
    }

    internal fun build(): AzureFileShareConfigurationArgs = AzureFileShareConfigurationArgs(
        accountKey = accountKey ?: throw PulumiNullFieldException("accountKey"),
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        azureFileUrl = azureFileUrl ?: throw PulumiNullFieldException("azureFileUrl"),
        mountOptions = mountOptions,
        relativeMountPath = relativeMountPath ?: throw PulumiNullFieldException("relativeMountPath"),
    )
}
