@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.CIFSMountConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountOptions These are 'net use' options in Windows and 'mount' options in Linux.
 * @property password
 * @property relativeMountPath All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
 * @property source
 * @property userName
 */
public data class CIFSMountConfigurationArgs(
    public val mountOptions: Output<String>? = null,
    public val password: Output<String>,
    public val relativeMountPath: Output<String>,
    public val source: Output<String>,
    public val userName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.CIFSMountConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.CIFSMountConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.CIFSMountConfigurationArgs.builder()
            .mountOptions(mountOptions?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .relativeMountPath(relativeMountPath.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CIFSMountConfigurationArgs].
 */
@PulumiTagMarker
public class CIFSMountConfigurationArgsBuilder internal constructor() {
    private var mountOptions: Output<String>? = null

    private var password: Output<String>? = null

    private var relativeMountPath: Output<String>? = null

    private var source: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("qmcrlkhontmfwroj")
    public suspend fun mountOptions(`value`: Output<String>) {
        this.mountOptions = value
    }

    /**
     * @param value
     */
    @JvmName("eowrvehjnjwlaktm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("xsnqwjgljomnbsgp")
    public suspend fun relativeMountPath(`value`: Output<String>) {
        this.relativeMountPath = value
    }

    /**
     * @param value
     */
    @JvmName("vawcfqoscunrgqcr")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value
     */
    @JvmName("rmpafskswthcrcjj")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value These are 'net use' options in Windows and 'mount' options in Linux.
     */
    @JvmName("unihtsxnooonigsb")
    public suspend fun mountOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("slpaoskskrkfmkaw")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     */
    @JvmName("tjhistdcxtcsoxqv")
    public suspend fun relativeMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relativeMountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("uimpnpdbxorgcgqs")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value
     */
    @JvmName("vskremhshejfbxfo")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): CIFSMountConfigurationArgs = CIFSMountConfigurationArgs(
        mountOptions = mountOptions,
        password = password ?: throw PulumiNullFieldException("password"),
        relativeMountPath = relativeMountPath ?: throw PulumiNullFieldException("relativeMountPath"),
        source = source ?: throw PulumiNullFieldException("source"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
