@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.ContainerRegistryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property identityReference The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property password
 * @property registryServer If omitted, the default is "docker.io".
 * @property userName
 */
public data class ContainerRegistryArgs(
    public val identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null,
    public val password: Output<String>? = null,
    public val registryServer: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.ContainerRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.ContainerRegistryArgs =
        com.pulumi.azurenative.batch.inputs.ContainerRegistryArgs.builder()
            .identityReference(identityReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(password?.applyValue({ args0 -> args0 }))
            .registryServer(registryServer?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryArgs].
 */
@PulumiTagMarker
public class ContainerRegistryArgsBuilder internal constructor() {
    private var identityReference: Output<ComputeNodeIdentityReferenceArgs>? = null

    private var password: Output<String>? = null

    private var registryServer: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("tidokahoielrtmpu")
    public suspend fun identityReference(`value`: Output<ComputeNodeIdentityReferenceArgs>) {
        this.identityReference = value
    }

    /**
     * @param value
     */
    @JvmName("kusudpowkwqrbqeg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value If omitted, the default is "docker.io".
     */
    @JvmName("pyvrgijynfqfaidp")
    public suspend fun registryServer(`value`: Output<String>) {
        this.registryServer = value
    }

    /**
     * @param value
     */
    @JvmName("qehlpedbdjtmwsyh")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("mvnpetopwwrhqpbd")
    public suspend fun identityReference(`value`: ComputeNodeIdentityReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityReference = mapped
    }

    /**
     * @param argument The reference to a user assigned identity associated with the Batch pool which a compute node will use.
     */
    @JvmName("ajxautxislnvxeqw")
    public suspend
    fun identityReference(argument: suspend ComputeNodeIdentityReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeNodeIdentityReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityReference = mapped
    }

    /**
     * @param value
     */
    @JvmName("ltcmkxtbmwfbbmea")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value If omitted, the default is "docker.io".
     */
    @JvmName("xmxvjvmqfutcaxmq")
    public suspend fun registryServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryServer = mapped
    }

    /**
     * @param value
     */
    @JvmName("oxmvrmmpwjffbjen")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ContainerRegistryArgs = ContainerRegistryArgs(
        identityReference = identityReference,
        password = password,
        registryServer = registryServer,
        userName = userName,
    )
}
