@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.IPRuleArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.IPRuleAction
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Rule to filter client IP address.
 * @property action Action when client IP address is matched.
 * @property value IPv4 address, or IPv4 address range in CIDR format.
 */
public data class IPRuleArgs(
    public val action: Output<IPRuleAction>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.IPRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.IPRuleArgs =
        com.pulumi.azurenative.batch.inputs.IPRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPRuleArgs].
 */
@PulumiTagMarker
public class IPRuleArgsBuilder internal constructor() {
    private var action: Output<IPRuleAction>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Action when client IP address is matched.
     */
    @JvmName("puwssfxbarmvqqfk")
    public suspend fun action(`value`: Output<IPRuleAction>) {
        this.action = value
    }

    /**
     * @param value IPv4 address, or IPv4 address range in CIDR format.
     */
    @JvmName("vyxocrnrutkmbgvs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Action when client IP address is matched.
     */
    @JvmName("xmatpdjcdlsttkiw")
    public suspend fun action(`value`: IPRuleAction) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IPv4 address, or IPv4 address range in CIDR format.
     */
    @JvmName("csobkxhxkvxlixft")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IPRuleArgs = IPRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
