@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.
 * @property keyIdentifier Full path to the secret with or without version. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. or https://mykeyvault.vault.azure.net/keys/testkey. To be usable the following prerequisites must be met:
 *  The Batch Account has a System Assigned identity
 *  The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
 *  The KeyVault has soft-delete and purge protection enabled
 */
public data class KeyVaultPropertiesArgs(
    public val keyIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.batch.inputs.KeyVaultPropertiesArgs.builder()
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyIdentifier: Output<String>? = null

    /**
     * @param value Full path to the secret with or without version. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. or https://mykeyvault.vault.azure.net/keys/testkey. To be usable the following prerequisites must be met:
     *  The Batch Account has a System Assigned identity
     *  The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
     *  The KeyVault has soft-delete and purge protection enabled
     */
    @JvmName("eamuwpqikyrjdacc")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value Full path to the secret with or without version. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. or https://mykeyvault.vault.azure.net/keys/testkey. To be usable the following prerequisites must be met:
     *  The Batch Account has a System Assigned identity
     *  The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
     *  The KeyVault has soft-delete and purge protection enabled
     */
    @JvmName("eohquhnvxtvspkdc")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyIdentifier = keyIdentifier,
    )
}
