@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.NodePlacementConfigurationArgs.builder
import com.pulumi.azurenative.batch.kotlin.enums.NodePlacementPolicyType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allocation configuration used by Batch Service to provision the nodes.
 * @property policy Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
 */
public data class NodePlacementConfigurationArgs(
    public val policy: Output<NodePlacementPolicyType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.NodePlacementConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.NodePlacementConfigurationArgs =
        com.pulumi.azurenative.batch.inputs.NodePlacementConfigurationArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NodePlacementConfigurationArgs].
 */
@PulumiTagMarker
public class NodePlacementConfigurationArgsBuilder internal constructor() {
    private var policy: Output<NodePlacementPolicyType>? = null

    /**
     * @param value Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
     */
    @JvmName("veatwstdgqvbpuea")
    public suspend fun policy(`value`: Output<NodePlacementPolicyType>) {
        this.policy = value
    }

    /**
     * @param value Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy.
     */
    @JvmName("luyhrgqnwvttnban")
    public suspend fun policy(`value`: NodePlacementPolicyType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): NodePlacementConfigurationArgs = NodePlacementConfigurationArgs(
        policy = policy,
    )
}
