@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.OSDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ephemeralOSDiskSettings
 */
public data class OSDiskArgs(
    public val ephemeralOSDiskSettings: Output<DiffDiskSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.OSDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.OSDiskArgs =
        com.pulumi.azurenative.batch.inputs.OSDiskArgs.builder()
            .ephemeralOSDiskSettings(
                ephemeralOSDiskSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OSDiskArgs].
 */
@PulumiTagMarker
public class OSDiskArgsBuilder internal constructor() {
    private var ephemeralOSDiskSettings: Output<DiffDiskSettingsArgs>? = null

    /**
     * @param value
     */
    @JvmName("qarphjruwgvljeuo")
    public suspend fun ephemeralOSDiskSettings(`value`: Output<DiffDiskSettingsArgs>) {
        this.ephemeralOSDiskSettings = value
    }

    /**
     * @param value
     */
    @JvmName("fntujsspuwtbxrwy")
    public suspend fun ephemeralOSDiskSettings(`value`: DiffDiskSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralOSDiskSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("muwpgfvcokottvsm")
    public suspend
    fun ephemeralOSDiskSettings(argument: suspend DiffDiskSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DiffDiskSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralOSDiskSettings = mapped
    }

    internal fun build(): OSDiskArgs = OSDiskArgs(
        ephemeralOSDiskSettings = ephemeralOSDiskSettings,
    )
}
