@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.StartTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
 * @property commandLine The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
 * @property containerSettings When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
 * @property environmentSettings
 * @property maxTaskRetryCount The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit. Default is 0.
 * @property resourceFiles
 * @property userIdentity If omitted, the task runs as a non-administrative user unique to the task.
 * @property waitForSuccess If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
 */
public data class StartTaskArgs(
    public val commandLine: Output<String>? = null,
    public val containerSettings: Output<TaskContainerSettingsArgs>? = null,
    public val environmentSettings: Output<List<EnvironmentSettingArgs>>? = null,
    public val maxTaskRetryCount: Output<Int>? = null,
    public val resourceFiles: Output<List<ResourceFileArgs>>? = null,
    public val userIdentity: Output<UserIdentityArgs>? = null,
    public val waitForSuccess: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.StartTaskArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.StartTaskArgs =
        com.pulumi.azurenative.batch.inputs.StartTaskArgs.builder()
            .commandLine(commandLine?.applyValue({ args0 -> args0 }))
            .containerSettings(containerSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentSettings(
                environmentSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxTaskRetryCount(maxTaskRetryCount?.applyValue({ args0 -> args0 }))
            .resourceFiles(
                resourceFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userIdentity(userIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .waitForSuccess(waitForSuccess?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StartTaskArgs].
 */
@PulumiTagMarker
public class StartTaskArgsBuilder internal constructor() {
    private var commandLine: Output<String>? = null

    private var containerSettings: Output<TaskContainerSettingsArgs>? = null

    private var environmentSettings: Output<List<EnvironmentSettingArgs>>? = null

    private var maxTaskRetryCount: Output<Int>? = null

    private var resourceFiles: Output<List<ResourceFileArgs>>? = null

    private var userIdentity: Output<UserIdentityArgs>? = null

    private var waitForSuccess: Output<Boolean>? = null

    /**
     * @param value The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
     */
    @JvmName("hvoccqoaplascfau")
    public suspend fun commandLine(`value`: Output<String>) {
        this.commandLine = value
    }

    /**
     * @param value When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
     */
    @JvmName("kvjqksgareknxmbx")
    public suspend fun containerSettings(`value`: Output<TaskContainerSettingsArgs>) {
        this.containerSettings = value
    }

    /**
     * @param value
     */
    @JvmName("ywtglgiolrwripui")
    public suspend fun environmentSettings(`value`: Output<List<EnvironmentSettingArgs>>) {
        this.environmentSettings = value
    }

    @JvmName("vtyvdecdljmqirni")
    public suspend fun environmentSettings(vararg values: Output<EnvironmentSettingArgs>) {
        this.environmentSettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ymkbsdmlqdnyampj")
    public suspend fun environmentSettings(values: List<Output<EnvironmentSettingArgs>>) {
        this.environmentSettings = Output.all(values)
    }

    /**
     * @param value The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit. Default is 0.
     */
    @JvmName("kgodyudeapuveqgg")
    public suspend fun maxTaskRetryCount(`value`: Output<Int>) {
        this.maxTaskRetryCount = value
    }

    /**
     * @param value
     */
    @JvmName("bssgbliaovqcakmu")
    public suspend fun resourceFiles(`value`: Output<List<ResourceFileArgs>>) {
        this.resourceFiles = value
    }

    @JvmName("cmuewwyxofypkeaq")
    public suspend fun resourceFiles(vararg values: Output<ResourceFileArgs>) {
        this.resourceFiles = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iuxfapappnmmiimr")
    public suspend fun resourceFiles(values: List<Output<ResourceFileArgs>>) {
        this.resourceFiles = Output.all(values)
    }

    /**
     * @param value If omitted, the task runs as a non-administrative user unique to the task.
     */
    @JvmName("gnajmwaxqaungfhe")
    public suspend fun userIdentity(`value`: Output<UserIdentityArgs>) {
        this.userIdentity = value
    }

    /**
     * @param value If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
     */
    @JvmName("gdhmetmqxvqggrvp")
    public suspend fun waitForSuccess(`value`: Output<Boolean>) {
        this.waitForSuccess = value
    }

    /**
     * @param value The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
     */
    @JvmName("rkvcuccdxeeaoeol")
    public suspend fun commandLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandLine = mapped
    }

    /**
     * @param value When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
     */
    @JvmName("xdpdvcyuptkflvkk")
    public suspend fun containerSettings(`value`: TaskContainerSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerSettings = mapped
    }

    /**
     * @param argument When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
     */
    @JvmName("esfbafboxggcynxy")
    public suspend
    fun containerSettings(argument: suspend TaskContainerSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TaskContainerSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("rrvcphvsotrbpfum")
    public suspend fun environmentSettings(`value`: List<EnvironmentSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wpyhulofcpkercki")
    public suspend
    fun environmentSettings(argument: List<suspend EnvironmentSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("olacdbhjrlatycae")
    public suspend fun environmentSettings(
        vararg
        argument: suspend EnvironmentSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nytlcivprsnyibhe")
    public suspend
    fun environmentSettings(argument: suspend EnvironmentSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentSettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("rxrmuptihifdsafw")
    public suspend fun environmentSettings(vararg values: EnvironmentSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentSettings = mapped
    }

    /**
     * @param value The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit. Default is 0.
     */
    @JvmName("tjherrjtbcvgnney")
    public suspend fun maxTaskRetryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTaskRetryCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("wqiafvfwcddggxxv")
    public suspend fun resourceFiles(`value`: List<ResourceFileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceFiles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("njekbmvvgiqufnlo")
    public suspend fun resourceFiles(argument: List<suspend ResourceFileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceFileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceFiles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mrojqacxxqtjeoxf")
    public suspend fun resourceFiles(vararg argument: suspend ResourceFileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceFileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceFiles = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hfyswbwaxycvcnxf")
    public suspend fun resourceFiles(argument: suspend ResourceFileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceFileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceFiles = mapped
    }

    /**
     * @param values
     */
    @JvmName("bsfdittkalmjmdxr")
    public suspend fun resourceFiles(vararg values: ResourceFileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceFiles = mapped
    }

    /**
     * @param value If omitted, the task runs as a non-administrative user unique to the task.
     */
    @JvmName("tmbcmbeklnywtaiu")
    public suspend fun userIdentity(`value`: UserIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIdentity = mapped
    }

    /**
     * @param argument If omitted, the task runs as a non-administrative user unique to the task.
     */
    @JvmName("recrtnmpodaviuxu")
    public suspend fun userIdentity(argument: suspend UserIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userIdentity = mapped
    }

    /**
     * @param value If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
     */
    @JvmName("cmrjugedvlqtwjbt")
    public suspend fun waitForSuccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForSuccess = mapped
    }

    internal fun build(): StartTaskArgs = StartTaskArgs(
        commandLine = commandLine,
        containerSettings = containerSettings,
        environmentSettings = environmentSettings,
        maxTaskRetryCount = maxTaskRetryCount,
        resourceFiles = resourceFiles,
        userIdentity = userIdentity,
        waitForSuccess = waitForSuccess,
    )
}
