@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.inputs

import com.pulumi.azurenative.batch.inputs.UserIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specify either the userName or autoUser property, but not both.
 * @property autoUser The userName and autoUser properties are mutually exclusive; you must specify one but not both.
 * @property userName The userName and autoUser properties are mutually exclusive; you must specify one but not both.
 */
public data class UserIdentityArgs(
    public val autoUser: Output<AutoUserSpecificationArgs>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.batch.inputs.UserIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.batch.inputs.UserIdentityArgs =
        com.pulumi.azurenative.batch.inputs.UserIdentityArgs.builder()
            .autoUser(autoUser?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityArgs].
 */
@PulumiTagMarker
public class UserIdentityArgsBuilder internal constructor() {
    private var autoUser: Output<AutoUserSpecificationArgs>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The userName and autoUser properties are mutually exclusive; you must specify one but not both.
     */
    @JvmName("fndgatmaoxxhcnwo")
    public suspend fun autoUser(`value`: Output<AutoUserSpecificationArgs>) {
        this.autoUser = value
    }

    /**
     * @param value The userName and autoUser properties are mutually exclusive; you must specify one but not both.
     */
    @JvmName("mplhlqgaqbprgoxc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The userName and autoUser properties are mutually exclusive; you must specify one but not both.
     */
    @JvmName("eteupplhswyonluj")
    public suspend fun autoUser(`value`: AutoUserSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUser = mapped
    }

    /**
     * @param argument The userName and autoUser properties are mutually exclusive; you must specify one but not both.
     */
    @JvmName("shiraaurfxrapwju")
    public suspend fun autoUser(argument: suspend AutoUserSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = AutoUserSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoUser = mapped
    }

    /**
     * @param value The userName and autoUser properties are mutually exclusive; you must specify one but not both.
     */
    @JvmName("liphwpnsoyemojtg")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserIdentityArgs = UserIdentityArgs(
        autoUser = autoUser,
        userName = userName,
    )
}
