@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identityReference The reference to a user assigned identity associated with the Batch pool which a compute node will use.
 * @property password
 * @property registryServer If omitted, the default is "docker.io".
 * @property userName
 */
public data class ContainerRegistryResponse(
    public val identityReference: ComputeNodeIdentityReferenceResponse? = null,
    public val password: String? = null,
    public val registryServer: String? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ContainerRegistryResponse):
            ContainerRegistryResponse = ContainerRegistryResponse(
            identityReference = javaType.identityReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ComputeNodeIdentityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            registryServer = javaType.registryServer().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
