@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property placement This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
 */
public data class DiffDiskSettingsResponse(
    public val placement: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.DiffDiskSettingsResponse):
            DiffDiskSettingsResponse = DiffDiskSettingsResponse(
            placement = javaType.placement().map({ args0 -> args0 }).orElse(null),
        )
    }
}
