@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Suppress

/**
 * Network profile for Batch account, which contains network rule settings for each endpoint.
 * @property accountAccess Network access profile for batchAccount endpoint (Batch account data plane API).
 * @property nodeManagementAccess Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
 */
public data class NetworkProfileResponse(
    public val accountAccess: EndpointAccessProfileResponse? = null,
    public val nodeManagementAccess: EndpointAccessProfileResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.NetworkProfileResponse):
            NetworkProfileResponse = NetworkProfileResponse(
            accountAccess = javaType.accountAccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.EndpointAccessProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodeManagementAccess = javaType.nodeManagementAccess().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.EndpointAccessProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
