@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Suppress

/**
 * Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 * @property autoScale This property and fixedScale are mutually exclusive and one of the properties must be specified.
 * @property fixedScale This property and autoScale are mutually exclusive and one of the properties must be specified.
 */
public data class ScaleSettingsResponse(
    public val autoScale: AutoScaleSettingsResponse? = null,
    public val fixedScale: FixedScaleSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ScaleSettingsResponse):
            ScaleSettingsResponse = ScaleSettingsResponse(
            autoScale = javaType.autoScale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AutoScaleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fixedScale = javaType.fixedScale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.FixedScaleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
