@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A VM Family and its associated core quota for the Batch account.
 * @property coreQuota The core quota for the VM family for the Batch account.
 * @property name The Virtual Machine family name.
 */
public data class VirtualMachineFamilyCoreQuotaResponse(
    public val coreQuota: Int,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.VirtualMachineFamilyCoreQuotaResponse):
            VirtualMachineFamilyCoreQuotaResponse = VirtualMachineFamilyCoreQuotaResponse(
            coreQuota = javaType.coreQuota(),
            name = javaType.name(),
        )
    }
}
