@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin

import com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The role assignment
 * Azure REST API version: 2019-10-01-preview. Prior API version in Azure Native 1.x: 2019-10-01-preview.
 * ## Example Usage
 * ### PutEnrollmentAdministratorRoleAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var billingRoleAssignmentByBillingAccount = new AzureNative.Billing.BillingRoleAssignmentByBillingAccount("billingRoleAssignmentByBillingAccount", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingRoleAssignmentName = "{billingRoleAssignmentName}",
 *         PrincipalId = "99a1a759-30dd-42c2-828c-db398826bb67",
 *         PrincipalTenantId = "7ca289b9-c32d-4f01-8566-7ff93261d76f",
 *         RoleDefinitionId = "/providers/Microsoft.Billing/billingAccounts/7898901/billingRoleDefinitions/9f1983cb-2574-400c-87e9-34cf8e2280db",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/billing/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := billing.NewBillingRoleAssignmentByBillingAccount(ctx, "billingRoleAssignmentByBillingAccount", &billing.BillingRoleAssignmentByBillingAccountArgs{
 * 			BillingAccountName:        pulumi.String("{billingAccountName}"),
 * 			BillingRoleAssignmentName: pulumi.String("{billingRoleAssignmentName}"),
 * 			PrincipalId:               pulumi.String("99a1a759-30dd-42c2-828c-db398826bb67"),
 * 			PrincipalTenantId:         pulumi.String("7ca289b9-c32d-4f01-8566-7ff93261d76f"),
 * 			RoleDefinitionId:          pulumi.String("/providers/Microsoft.Billing/billingAccounts/7898901/billingRoleDefinitions/9f1983cb-2574-400c-87e9-34cf8e2280db"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccount;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var billingRoleAssignmentByBillingAccount = new BillingRoleAssignmentByBillingAccount("billingRoleAssignmentByBillingAccount", BillingRoleAssignmentByBillingAccountArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingRoleAssignmentName("{billingRoleAssignmentName}")
 *             .principalId("99a1a759-30dd-42c2-828c-db398826bb67")
 *             .principalTenantId("7ca289b9-c32d-4f01-8566-7ff93261d76f")
 *             .roleDefinitionId("/providers/Microsoft.Billing/billingAccounts/7898901/billingRoleDefinitions/9f1983cb-2574-400c-87e9-34cf8e2280db")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:billing:BillingRoleAssignmentByBillingAccount 9dfd08c2-62a3-4d47-85bd-1cdba1408402 /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingRoleAssignments/{billingRoleAssignmentName}
 * ```
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingRoleAssignmentName The ID that uniquely identifies a role assignment.
 * @property principalId The principal id of the user to whom the role was assigned.
 * @property principalTenantId The principal tenant id of the user to whom the role was assigned.
 * @property roleDefinitionId The ID of the role definition.
 * @property userAuthenticationType The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 * @property userEmailAddress The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 */
public data class BillingRoleAssignmentByBillingAccountArgs(
    public val billingAccountName: Output<String>? = null,
    public val billingRoleAssignmentName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalTenantId: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val userAuthenticationType: Output<String>? = null,
    public val userEmailAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccountArgs =
        com.pulumi.azurenative.billing.BillingRoleAssignmentByBillingAccountArgs.builder()
            .billingAccountName(billingAccountName?.applyValue({ args0 -> args0 }))
            .billingRoleAssignmentName(billingRoleAssignmentName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalTenantId(principalTenantId?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .userAuthenticationType(userAuthenticationType?.applyValue({ args0 -> args0 }))
            .userEmailAddress(userEmailAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BillingRoleAssignmentByBillingAccountArgs].
 */
@PulumiTagMarker
public class BillingRoleAssignmentByBillingAccountArgsBuilder internal constructor() {
    private var billingAccountName: Output<String>? = null

    private var billingRoleAssignmentName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalTenantId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var userAuthenticationType: Output<String>? = null

    private var userEmailAddress: Output<String>? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("slujixkataqdwbxt")
    public suspend fun billingAccountName(`value`: Output<String>) {
        this.billingAccountName = value
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("flfwyhawnqwlkajn")
    public suspend fun billingRoleAssignmentName(`value`: Output<String>) {
        this.billingRoleAssignmentName = value
    }

    /**
     * @param value The principal id of the user to whom the role was assigned.
     */
    @JvmName("xjjculcifppednex")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The principal tenant id of the user to whom the role was assigned.
     */
    @JvmName("lfaegqtvrwaomqqk")
    public suspend fun principalTenantId(`value`: Output<String>) {
        this.principalTenantId = value
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("yrpsjftoglcemmjh")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("mtcufgjvmlahqpax")
    public suspend fun userAuthenticationType(`value`: Output<String>) {
        this.userAuthenticationType = value
    }

    /**
     * @param value The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("aphavsbjskxfqyue")
    public suspend fun userEmailAddress(`value`: Output<String>) {
        this.userEmailAddress = value
    }

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("drhpdoqhpkxnmmmw")
    public suspend fun billingAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("milpagqeimgexwvc")
    public suspend fun billingRoleAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingRoleAssignmentName = mapped
    }

    /**
     * @param value The principal id of the user to whom the role was assigned.
     */
    @JvmName("gnsimsyrggsmonqr")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The principal tenant id of the user to whom the role was assigned.
     */
    @JvmName("xxjuhkwfbuyfvito")
    public suspend fun principalTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalTenantId = mapped
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("kahwghqljnrjxogt")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("qdywgmrqxjbqaijs")
    public suspend fun userAuthenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthenticationType = mapped
    }

    /**
     * @param value The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("iuidyxdjqoobfamc")
    public suspend fun userEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEmailAddress = mapped
    }

    internal fun build(): BillingRoleAssignmentByBillingAccountArgs =
        BillingRoleAssignmentByBillingAccountArgs(
            billingAccountName = billingAccountName,
            billingRoleAssignmentName = billingRoleAssignmentName,
            principalId = principalId,
            principalTenantId = principalTenantId,
            roleDefinitionId = roleDefinitionId,
            userAuthenticationType = userAuthenticationType,
            userEmailAddress = userEmailAddress,
        )
}
