@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin

import com.pulumi.azurenative.blockchain.BlockchainFunctions.getBlockchainMemberPlain
import com.pulumi.azurenative.blockchain.BlockchainFunctions.getTransactionNodePlain
import com.pulumi.azurenative.blockchain.BlockchainFunctions.listBlockchainMemberApiKeysPlain
import com.pulumi.azurenative.blockchain.BlockchainFunctions.listLocationConsortiumsPlain
import com.pulumi.azurenative.blockchain.BlockchainFunctions.listTransactionNodeApiKeysPlain
import com.pulumi.azurenative.blockchain.kotlin.inputs.GetBlockchainMemberPlainArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.GetBlockchainMemberPlainArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.GetTransactionNodePlainArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.GetTransactionNodePlainArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListBlockchainMemberApiKeysPlainArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListBlockchainMemberApiKeysPlainArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListLocationConsortiumsPlainArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListLocationConsortiumsPlainArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListTransactionNodeApiKeysPlainArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.ListTransactionNodeApiKeysPlainArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.outputs.GetBlockchainMemberResult
import com.pulumi.azurenative.blockchain.kotlin.outputs.GetTransactionNodeResult
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListBlockchainMemberApiKeysResult
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListLocationConsortiumsResult
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListTransactionNodeApiKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.blockchain.kotlin.outputs.GetBlockchainMemberResult.Companion.toKotlin as getBlockchainMemberResultToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.GetTransactionNodeResult.Companion.toKotlin as getTransactionNodeResultToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListBlockchainMemberApiKeysResult.Companion.toKotlin as listBlockchainMemberApiKeysResultToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListLocationConsortiumsResult.Companion.toKotlin as listLocationConsortiumsResultToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.ListTransactionNodeApiKeysResult.Companion.toKotlin as listTransactionNodeApiKeysResultToKotlin

public object BlockchainFunctions {
    /**
     * Get details about a blockchain member.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Payload of the blockchain member which is exposed in the request/response of the resource provider.
     */
    public suspend fun getBlockchainMember(argument: GetBlockchainMemberPlainArgs):
        GetBlockchainMemberResult =
        getBlockchainMemberResultToKotlin(getBlockchainMemberPlain(argument.toJava()).await())

    /**
     * @see [getBlockchainMember].
     * @param blockchainMemberName Blockchain member name.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return Payload of the blockchain member which is exposed in the request/response of the resource provider.
     */
    public suspend fun getBlockchainMember(blockchainMemberName: String, resourceGroupName: String):
        GetBlockchainMemberResult {
        val argument = GetBlockchainMemberPlainArgs(
            blockchainMemberName = blockchainMemberName,
            resourceGroupName = resourceGroupName,
        )
        return getBlockchainMemberResultToKotlin(getBlockchainMemberPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlockchainMember].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blockchain&#46;kotlin&#46;inputs&#46;GetBlockchainMemberPlainArgs].
     * @return Payload of the blockchain member which is exposed in the request/response of the resource provider.
     */
    public suspend
    fun getBlockchainMember(argument: suspend GetBlockchainMemberPlainArgsBuilder.() -> Unit):
        GetBlockchainMemberResult {
        val builder = GetBlockchainMemberPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlockchainMemberResultToKotlin(getBlockchainMemberPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of the transaction node.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Payload of the transaction node which is the request/response of the resource provider.
     */
    public suspend fun getTransactionNode(argument: GetTransactionNodePlainArgs):
        GetTransactionNodeResult =
        getTransactionNodeResultToKotlin(getTransactionNodePlain(argument.toJava()).await())

    /**
     * @see [getTransactionNode].
     * @param blockchainMemberName Blockchain member name.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param transactionNodeName Transaction node name.
     * @return Payload of the transaction node which is the request/response of the resource provider.
     */
    public suspend fun getTransactionNode(
        blockchainMemberName: String,
        resourceGroupName: String,
        transactionNodeName: String,
    ): GetTransactionNodeResult {
        val argument = GetTransactionNodePlainArgs(
            blockchainMemberName = blockchainMemberName,
            resourceGroupName = resourceGroupName,
            transactionNodeName = transactionNodeName,
        )
        return getTransactionNodeResultToKotlin(getTransactionNodePlain(argument.toJava()).await())
    }

    /**
     * @see [getTransactionNode].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blockchain&#46;kotlin&#46;inputs&#46;GetTransactionNodePlainArgs].
     * @return Payload of the transaction node which is the request/response of the resource provider.
     */
    public suspend
    fun getTransactionNode(argument: suspend GetTransactionNodePlainArgsBuilder.() -> Unit):
        GetTransactionNodeResult {
        val builder = GetTransactionNodePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransactionNodeResultToKotlin(getTransactionNodePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the API keys for a blockchain member.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend fun listBlockchainMemberApiKeys(argument: ListBlockchainMemberApiKeysPlainArgs):
        ListBlockchainMemberApiKeysResult =
        listBlockchainMemberApiKeysResultToKotlin(listBlockchainMemberApiKeysPlain(argument.toJava()).await())

    /**
     * @see [listBlockchainMemberApiKeys].
     * @param blockchainMemberName Blockchain member name.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend fun listBlockchainMemberApiKeys(
        blockchainMemberName: String,
        resourceGroupName: String,
    ): ListBlockchainMemberApiKeysResult {
        val argument = ListBlockchainMemberApiKeysPlainArgs(
            blockchainMemberName = blockchainMemberName,
            resourceGroupName = resourceGroupName,
        )
        return listBlockchainMemberApiKeysResultToKotlin(listBlockchainMemberApiKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listBlockchainMemberApiKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blockchain&#46;kotlin&#46;inputs&#46;ListBlockchainMemberApiKeysPlainArgs].
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend
    fun listBlockchainMemberApiKeys(argument: suspend ListBlockchainMemberApiKeysPlainArgsBuilder.() -> Unit):
        ListBlockchainMemberApiKeysResult {
        val builder = ListBlockchainMemberApiKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBlockchainMemberApiKeysResultToKotlin(listBlockchainMemberApiKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the available consortiums for a subscription.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Collection of the consortium payload.
     */
    public suspend fun listLocationConsortiums(argument: ListLocationConsortiumsPlainArgs):
        ListLocationConsortiumsResult =
        listLocationConsortiumsResultToKotlin(listLocationConsortiumsPlain(argument.toJava()).await())

    /**
     * @see [listLocationConsortiums].
     * @param locationName Location Name.
     * @return Collection of the consortium payload.
     */
    public suspend fun listLocationConsortiums(locationName: String): ListLocationConsortiumsResult {
        val argument = ListLocationConsortiumsPlainArgs(
            locationName = locationName,
        )
        return listLocationConsortiumsResultToKotlin(listLocationConsortiumsPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocationConsortiums].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blockchain&#46;kotlin&#46;inputs&#46;ListLocationConsortiumsPlainArgs].
     * @return Collection of the consortium payload.
     */
    public suspend
    fun listLocationConsortiums(argument: suspend ListLocationConsortiumsPlainArgsBuilder.() -> Unit):
        ListLocationConsortiumsResult {
        val builder = ListLocationConsortiumsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocationConsortiumsResultToKotlin(listLocationConsortiumsPlain(builtArgument.toJava()).await())
    }

    /**
     * List the API keys for the transaction node.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend fun listTransactionNodeApiKeys(argument: ListTransactionNodeApiKeysPlainArgs):
        ListTransactionNodeApiKeysResult =
        listTransactionNodeApiKeysResultToKotlin(listTransactionNodeApiKeysPlain(argument.toJava()).await())

    /**
     * @see [listTransactionNodeApiKeys].
     * @param blockchainMemberName Blockchain member name.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param transactionNodeName Transaction node name.
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend fun listTransactionNodeApiKeys(
        blockchainMemberName: String,
        resourceGroupName: String,
        transactionNodeName: String,
    ): ListTransactionNodeApiKeysResult {
        val argument = ListTransactionNodeApiKeysPlainArgs(
            blockchainMemberName = blockchainMemberName,
            resourceGroupName = resourceGroupName,
            transactionNodeName = transactionNodeName,
        )
        return listTransactionNodeApiKeysResultToKotlin(listTransactionNodeApiKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listTransactionNodeApiKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blockchain&#46;kotlin&#46;inputs&#46;ListTransactionNodeApiKeysPlainArgs].
     * @return Collection of the API key payload which is exposed in the response of the resource provider.
     */
    public suspend
    fun listTransactionNodeApiKeys(argument: suspend ListTransactionNodeApiKeysPlainArgsBuilder.() -> Unit):
        ListTransactionNodeApiKeysResult {
        val builder = ListTransactionNodeApiKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTransactionNodeApiKeysResultToKotlin(listTransactionNodeApiKeysPlain(builtArgument.toJava()).await())
    }
}
