@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin

import com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse
import com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TransactionNode].
 */
@PulumiTagMarker
public class TransactionNodeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransactionNodeArgs = TransactionNodeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransactionNodeArgsBuilder.() -> Unit) {
        val builder = TransactionNodeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransactionNode {
        val builtJavaResource =
            com.pulumi.azurenative.blockchain.TransactionNode(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransactionNode(builtJavaResource)
    }
}

/**
 * Payload of the transaction node which is the request/response of the resource provider.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### TransactionNodes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var transactionNode = new AzureNative.Blockchain.TransactionNode("transactionNode", new()
 *     {
 *         BlockchainMemberName = "contosemember1",
 *         Location = "southeastasia",
 *         Password = "<password>",
 *         ResourceGroupName = "mygroup",
 *         TransactionNodeName = "txnode2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blockchain/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blockchain.NewTransactionNode(ctx, "transactionNode", &blockchain.TransactionNodeArgs{
 * 			BlockchainMemberName: pulumi.String("contosemember1"),
 * 			Location:             pulumi.String("southeastasia"),
 * 			Password:             pulumi.String("<password>"),
 * 			ResourceGroupName:    pulumi.String("mygroup"),
 * 			TransactionNodeName:  pulumi.String("txnode2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blockchain.TransactionNode;
 * import com.pulumi.azurenative.blockchain.TransactionNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transactionNode = new TransactionNode("transactionNode", TransactionNodeArgs.builder()
 *             .blockchainMemberName("contosemember1")
 *             .location("southeastasia")
 *             .password("<password>")
 *             .resourceGroupName("mygroup")
 *             .transactionNodeName("txnode2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blockchain:TransactionNode txnode2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}/transactionNodes/{transactionNodeName}
 * ```
 */
public class TransactionNode internal constructor(
    override val javaResource: com.pulumi.azurenative.blockchain.TransactionNode,
) : KotlinCustomResource(javaResource, TransactionNodeMapper) {
    /**
     * Gets or sets the transaction node dns endpoint.
     */
    public val dns: Output<String>
        get() = javaResource.dns().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the firewall rules.
     */
    public val firewallRules: Output<List<FirewallRuleResponse>>?
        get() = javaResource.firewallRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Gets or sets the transaction node location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sets the transaction node dns endpoint basic auth password.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the blockchain member provision state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the transaction node public key.
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * The type of the service - e.g. "Microsoft.Blockchain"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the transaction node dns endpoint basic auth user name.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object TransactionNodeMapper : ResourceMapper<TransactionNode> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blockchain.TransactionNode::class == javaResource::class

    override fun map(javaResource: Resource): TransactionNode = TransactionNode(
        javaResource as
            com.pulumi.azurenative.blockchain.TransactionNode,
    )
}

/**
 * @see [TransactionNode].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransactionNode].
 */
public suspend fun transactionNode(
    name: String,
    block: suspend TransactionNodeResourceBuilder.() -> Unit,
): TransactionNode {
    val builder = TransactionNodeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransactionNode].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transactionNode(name: String): TransactionNode {
    val builder = TransactionNodeResourceBuilder()
    builder.name(name)
    return builder.build()
}
