@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.GetBlockchainMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockchainMemberName Blockchain member name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetBlockchainMemberPlainArgs(
    public val blockchainMemberName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.GetBlockchainMemberPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.inputs.GetBlockchainMemberPlainArgs =
        com.pulumi.azurenative.blockchain.inputs.GetBlockchainMemberPlainArgs.builder()
            .blockchainMemberName(blockchainMemberName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlockchainMemberPlainArgs].
 */
@PulumiTagMarker
public class GetBlockchainMemberPlainArgsBuilder internal constructor() {
    private var blockchainMemberName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Blockchain member name.
     */
    @JvmName("vdfsymjrbcemmypi")
    public suspend fun blockchainMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blockchainMemberName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jqcbcgcxkitosfeu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBlockchainMemberPlainArgs = GetBlockchainMemberPlainArgs(
        blockchainMemberName = blockchainMemberName ?: throw
            PulumiNullFieldException("blockchainMemberName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
