@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Payload of the transaction node which is the request/response of the resource provider.
 * @property dns Gets or sets the transaction node dns endpoint.
 * @property firewallRules Gets or sets the firewall rules.
 * @property id Fully qualified resource Id of the resource.
 * @property location Gets or sets the transaction node location.
 * @property name The name of the resource.
 * @property password Sets the transaction node dns endpoint basic auth password.
 * @property provisioningState Gets or sets the blockchain member provision state.
 * @property publicKey Gets or sets the transaction node public key.
 * @property type The type of the service - e.g. "Microsoft.Blockchain"
 * @property userName Gets or sets the transaction node dns endpoint basic auth user name.
 */
public data class GetTransactionNodeResult(
    public val dns: String,
    public val firewallRules: List<FirewallRuleResponse>? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val password: String? = null,
    public val provisioningState: String,
    public val publicKey: String,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.GetTransactionNodeResult):
            GetTransactionNodeResult = GetTransactionNodeResult(
            dns = javaType.dns(),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
