@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Collection of the API key payload which is exposed in the response of the resource provider.
 * @property keys Gets or sets the collection of API key.
 */
public data class ListBlockchainMemberApiKeysResult(
    public val keys: List<ApiKeyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.ListBlockchainMemberApiKeysResult):
            ListBlockchainMemberApiKeysResult = ListBlockchainMemberApiKeysResult(
            keys = javaType.keys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blockchain.kotlin.outputs.ApiKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
