@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.AssignmentArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.inputs.AssignmentLockSettingsArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.AssignmentLockSettingsArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupValueArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a blueprint assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### Assignment with system-assigned managed identity at management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "managementGroups/ContosoOnlineGroup",
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("managementGroups/ContosoOnlineGroup"),
 * 			Scope:         pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("managementGroups/ContosoOnlineGroup")
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with system-assigned managed identity at subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: &blueprint.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with user-assigned managed identity at management group scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = "UserAssigned",
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", null },
 *             },
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "managementGroups/ContosoOnlineGroup",
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: blueprint.ManagedServiceIdentityResponse{
 * 				Type: pulumi.String("UserAssigned"),
 * 				UserAssignedIdentities: blueprint.UserAssignedIdentityMap{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("managementGroups/ContosoOnlineGroup"),
 * 			Scope:         pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", ))
 *             ))
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("managementGroups/ContosoOnlineGroup")
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Assignment with user-assigned managed identity at subscription scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Blueprint.Assignment("assignment", new()
 *     {
 *         AssignmentName = "assignSimpleBlueprint",
 *         BlueprintId = "/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint",
 *         Description = "enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.",
 *         Identity = new AzureNative.Blueprint.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = "UserAssigned",
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", null },
 *             },
 *         },
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Contoso/Online/Shopping/Production",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = new[]
 *                 {
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com",
 *                 },
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "Standard_LRS",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupValueArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "defaultRG",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewAssignment(ctx, "assignment", &blueprint.AssignmentArgs{
 * 			AssignmentName: pulumi.String("assignSimpleBlueprint"),
 * 			BlueprintId:    pulumi.String("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
 * 			Description:    pulumi.String("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription."),
 * 			Identity: blueprint.ManagedServiceIdentityResponse{
 * 				Type: pulumi.String("UserAssigned"),
 * 				UserAssignedIdentities: blueprint.UserAssignedIdentityMap{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"costCenter": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Contoso/Online/Shopping/Production"),
 * 				},
 * 				"owners": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any{
 * 						"johnDoe@contoso.com",
 * 						"johnsteam@contoso.com",
 * 					},
 * 				},
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("Standard_LRS"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupValueMap{
 * 				"storageRG": &blueprint.ResourceGroupValueArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("defaultRG"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Assignment;
 * import com.pulumi.azurenative.blueprint.AssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignmentName("assignSimpleBlueprint")
 *             .blueprintId("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint")
 *             .description("enforce pre-defined simpleBlueprint to this XXXXXXXX subscription.")
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resource-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/contoso-identity", ))
 *             ))
 *             .location("eastus")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.of("value", "Contoso/Online/Shopping/Production")),
 *                 Map.entry("owners", Map.of("value",
 *                     "johnDoe@contoso.com",
 *                     "johnsteam@contoso.com")),
 *                 Map.entry("storageAccountType", Map.of("value", "Standard_LRS"))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "defaultRG")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:Assignment assignSimpleBlueprint /{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}
 * ```
 * @property assignmentName Name of the blueprint assignment.
 * @property blueprintId ID of the published version of a blueprint definition.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property identity Managed identity for this blueprint assignment.
 * @property location The location of this blueprint assignment.
 * @property locks Defines how resources deployed by a blueprint assignment are locked.
 * @property parameters Blueprint assignment parameter values.
 * @property resourceGroups Names and locations of resource group placeholders.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property scope The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
 */
public data class AssignmentArgs(
    public val assignmentName: Output<String>? = null,
    public val blueprintId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val locks: Output<AssignmentLockSettingsArgs>? = null,
    public val parameters: Output<Map<String, ParameterValueArgs>>? = null,
    public val resourceGroups: Output<Map<String, ResourceGroupValueArgs>>? = null,
    public val resourceScope: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.AssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.AssignmentArgs =
        com.pulumi.azurenative.blueprint.AssignmentArgs.builder()
            .assignmentName(assignmentName?.applyValue({ args0 -> args0 }))
            .blueprintId(blueprintId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .locks(locks?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroups(
                resourceGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignmentArgs].
 */
@PulumiTagMarker
public class AssignmentArgsBuilder internal constructor() {
    private var assignmentName: Output<String>? = null

    private var blueprintId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var locks: Output<AssignmentLockSettingsArgs>? = null

    private var parameters: Output<Map<String, ParameterValueArgs>>? = null

    private var resourceGroups: Output<Map<String, ResourceGroupValueArgs>>? = null

    private var resourceScope: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value Name of the blueprint assignment.
     */
    @JvmName("qgsnwykyvgcfcsfr")
    public suspend fun assignmentName(`value`: Output<String>) {
        this.assignmentName = value
    }

    /**
     * @param value ID of the published version of a blueprint definition.
     */
    @JvmName("fyefgrffxmdedoec")
    public suspend fun blueprintId(`value`: Output<String>) {
        this.blueprintId = value
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("hogtxjmpsmpitlud")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("yadblcusoabiwrdy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Managed identity for this blueprint assignment.
     */
    @JvmName("inlejlkdwhwtriso")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of this blueprint assignment.
     */
    @JvmName("drjnukheeibnhdsm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Defines how resources deployed by a blueprint assignment are locked.
     */
    @JvmName("drtiusuaomgadwna")
    public suspend fun locks(`value`: Output<AssignmentLockSettingsArgs>) {
        this.locks = value
    }

    /**
     * @param value Blueprint assignment parameter values.
     */
    @JvmName("jpeempvooalltlve")
    public suspend fun parameters(`value`: Output<Map<String, ParameterValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Names and locations of resource group placeholders.
     */
    @JvmName("xwombcvectvfsqia")
    public suspend fun resourceGroups(`value`: Output<Map<String, ResourceGroupValueArgs>>) {
        this.resourceGroups = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("msubqfvciixejigb")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
     */
    @JvmName("gafkgnjgrlnptqyt")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the blueprint assignment.
     */
    @JvmName("iukxgsjrrsvgjrvm")
    public suspend fun assignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentName = mapped
    }

    /**
     * @param value ID of the published version of a blueprint definition.
     */
    @JvmName("hgajrcyjqstanqcq")
    public suspend fun blueprintId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintId = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("kldydgmokpnhrvjh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("tamrnlmxwiaifpqx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Managed identity for this blueprint assignment.
     */
    @JvmName("akfymjmldsrewpxe")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity for this blueprint assignment.
     */
    @JvmName("eernvngjcirjhdjp")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of this blueprint assignment.
     */
    @JvmName("xqxvmuadkruprvly")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Defines how resources deployed by a blueprint assignment are locked.
     */
    @JvmName("qfhhjgcwpaobefxe")
    public suspend fun locks(`value`: AssignmentLockSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locks = mapped
    }

    /**
     * @param argument Defines how resources deployed by a blueprint assignment are locked.
     */
    @JvmName("awtrghrbwxrarjui")
    public suspend fun locks(argument: suspend AssignmentLockSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AssignmentLockSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.locks = mapped
    }

    /**
     * @param value Blueprint assignment parameter values.
     */
    @JvmName("ywbrctjavudsltqb")
    public suspend fun parameters(`value`: Map<String, ParameterValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Blueprint assignment parameter values.
     */
    @JvmName("dnapgcyslrbpippo")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Blueprint assignment parameter values.
     */
    @JvmName("pyoexglqjljitxgk")
    public fun parameters(vararg values: Pair<String, ParameterValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Names and locations of resource group placeholders.
     */
    @JvmName("rskwumqrokkrtajh")
    public suspend fun resourceGroups(`value`: Map<String, ResourceGroupValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param argument Names and locations of resource group placeholders.
     */
    @JvmName("mxffthqrfnofycpn")
    public suspend fun resourceGroups(
        vararg
        argument: Pair<String, suspend ResourceGroupValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ResourceGroupValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.resourceGroups = mapped
    }

    /**
     * @param values Names and locations of resource group placeholders.
     */
    @JvmName("toubmkdejphmrqwf")
    public fun resourceGroups(vararg values: Pair<String, ResourceGroupValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("twadndetnmdshdur")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    /**
     * @param value The target subscription scope of the blueprint assignment (format: '/subscriptions/{subscriptionId}'). For management group level assignments, the property is required.
     */
    @JvmName("lhbrptsokmxqhhye")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): AssignmentArgs = AssignmentArgs(
        assignmentName = assignmentName,
        blueprintId = blueprintId,
        description = description,
        displayName = displayName,
        identity = identity,
        location = location,
        locks = locks,
        parameters = parameters,
        resourceGroups = resourceGroups,
        resourceScope = resourceScope,
        scope = scope,
    )
}
