@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.BlueprintFunctions.getAssignmentPlain
import com.pulumi.azurenative.blueprint.BlueprintFunctions.getBlueprintPlain
import com.pulumi.azurenative.blueprint.BlueprintFunctions.getPolicyAssignmentArtifactPlain
import com.pulumi.azurenative.blueprint.BlueprintFunctions.getPublishedBlueprintPlain
import com.pulumi.azurenative.blueprint.BlueprintFunctions.getRoleAssignmentArtifactPlain
import com.pulumi.azurenative.blueprint.BlueprintFunctions.getTemplateArtifactPlain
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetAssignmentPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetAssignmentPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetBlueprintPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetBlueprintPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetPolicyAssignmentArtifactPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetPolicyAssignmentArtifactPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetPublishedBlueprintPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetPublishedBlueprintPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetRoleAssignmentArtifactPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetRoleAssignmentArtifactPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetTemplateArtifactPlainArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.GetTemplateArtifactPlainArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetAssignmentResult
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetBlueprintResult
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetPolicyAssignmentArtifactResult
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetPublishedBlueprintResult
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetRoleAssignmentArtifactResult
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetTemplateArtifactResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetAssignmentResult.Companion.toKotlin as getAssignmentResultToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetBlueprintResult.Companion.toKotlin as getBlueprintResultToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetPolicyAssignmentArtifactResult.Companion.toKotlin as getPolicyAssignmentArtifactResultToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetPublishedBlueprintResult.Companion.toKotlin as getPublishedBlueprintResultToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetRoleAssignmentArtifactResult.Companion.toKotlin as getRoleAssignmentArtifactResultToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.GetTemplateArtifactResult.Companion.toKotlin as getTemplateArtifactResultToKotlin

public object BlueprintFunctions {
    /**
     * Get a blueprint assignment.
     * Azure REST API version: 2018-11-01-preview.
     * Other available API versions: 2017-11-11-preview.
     * @param argument null
     * @return Represents a blueprint assignment.
     */
    public suspend fun getAssignment(argument: GetAssignmentPlainArgs): GetAssignmentResult =
        getAssignmentResultToKotlin(getAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getAssignment].
     * @param assignmentName Name of the blueprint assignment.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @return Represents a blueprint assignment.
     */
    public suspend fun getAssignment(assignmentName: String, resourceScope: String):
        GetAssignmentResult {
        val argument = GetAssignmentPlainArgs(
            assignmentName = assignmentName,
            resourceScope = resourceScope,
        )
        return getAssignmentResultToKotlin(getAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetAssignmentPlainArgs].
     * @return Represents a blueprint assignment.
     */
    public suspend fun getAssignment(argument: suspend GetAssignmentPlainArgsBuilder.() -> Unit):
        GetAssignmentResult {
        val builder = GetAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssignmentResultToKotlin(getAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a blueprint definition.
     * Azure REST API version: 2018-11-01-preview.
     * Other available API versions: 2017-11-11-preview.
     * @param argument null
     * @return Represents a Blueprint definition.
     */
    public suspend fun getBlueprint(argument: GetBlueprintPlainArgs): GetBlueprintResult =
        getBlueprintResultToKotlin(getBlueprintPlain(argument.toJava()).await())

    /**
     * @see [getBlueprint].
     * @param blueprintName Name of the blueprint definition.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @return Represents a Blueprint definition.
     */
    public suspend fun getBlueprint(blueprintName: String, resourceScope: String):
        GetBlueprintResult {
        val argument = GetBlueprintPlainArgs(
            blueprintName = blueprintName,
            resourceScope = resourceScope,
        )
        return getBlueprintResultToKotlin(getBlueprintPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlueprint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetBlueprintPlainArgs].
     * @return Represents a Blueprint definition.
     */
    public suspend fun getBlueprint(argument: suspend GetBlueprintPlainArgsBuilder.() -> Unit):
        GetBlueprintResult {
        val builder = GetBlueprintPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlueprintResultToKotlin(getBlueprintPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a blueprint artifact.
     * Azure REST API version: 2018-11-01-preview.
     * @param argument null
     * @return Blueprint artifact that applies a Policy assignment.
     */
    public suspend fun getPolicyAssignmentArtifact(argument: GetPolicyAssignmentArtifactPlainArgs):
        GetPolicyAssignmentArtifactResult =
        getPolicyAssignmentArtifactResultToKotlin(getPolicyAssignmentArtifactPlain(argument.toJava()).await())

    /**
     * @see [getPolicyAssignmentArtifact].
     * @param artifactName Name of the blueprint artifact.
     * @param blueprintName Name of the blueprint definition.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @return Blueprint artifact that applies a Policy assignment.
     */
    public suspend fun getPolicyAssignmentArtifact(
        artifactName: String,
        blueprintName: String,
        resourceScope: String,
    ): GetPolicyAssignmentArtifactResult {
        val argument = GetPolicyAssignmentArtifactPlainArgs(
            artifactName = artifactName,
            blueprintName = blueprintName,
            resourceScope = resourceScope,
        )
        return getPolicyAssignmentArtifactResultToKotlin(getPolicyAssignmentArtifactPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyAssignmentArtifact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetPolicyAssignmentArtifactPlainArgs].
     * @return Blueprint artifact that applies a Policy assignment.
     */
    public suspend
    fun getPolicyAssignmentArtifact(argument: suspend GetPolicyAssignmentArtifactPlainArgsBuilder.() -> Unit):
        GetPolicyAssignmentArtifactResult {
        val builder = GetPolicyAssignmentArtifactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyAssignmentArtifactResultToKotlin(getPolicyAssignmentArtifactPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a published version of a blueprint definition.
     * Azure REST API version: 2018-11-01-preview.
     * Other available API versions: 2017-11-11-preview.
     * @param argument null
     * @return Represents a published blueprint.
     */
    public suspend fun getPublishedBlueprint(argument: GetPublishedBlueprintPlainArgs):
        GetPublishedBlueprintResult =
        getPublishedBlueprintResultToKotlin(getPublishedBlueprintPlain(argument.toJava()).await())

    /**
     * @see [getPublishedBlueprint].
     * @param blueprintName Name of the blueprint definition.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @param versionId Version of the published blueprint definition.
     * @return Represents a published blueprint.
     */
    public suspend fun getPublishedBlueprint(
        blueprintName: String,
        resourceScope: String,
        versionId: String,
    ): GetPublishedBlueprintResult {
        val argument = GetPublishedBlueprintPlainArgs(
            blueprintName = blueprintName,
            resourceScope = resourceScope,
            versionId = versionId,
        )
        return getPublishedBlueprintResultToKotlin(getPublishedBlueprintPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublishedBlueprint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetPublishedBlueprintPlainArgs].
     * @return Represents a published blueprint.
     */
    public suspend
    fun getPublishedBlueprint(argument: suspend GetPublishedBlueprintPlainArgsBuilder.() -> Unit):
        GetPublishedBlueprintResult {
        val builder = GetPublishedBlueprintPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublishedBlueprintResultToKotlin(getPublishedBlueprintPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a blueprint artifact.
     * Azure REST API version: 2018-11-01-preview.
     * @param argument null
     * @return Blueprint artifact that applies a Role assignment.
     */
    public suspend fun getRoleAssignmentArtifact(argument: GetRoleAssignmentArtifactPlainArgs):
        GetRoleAssignmentArtifactResult =
        getRoleAssignmentArtifactResultToKotlin(getRoleAssignmentArtifactPlain(argument.toJava()).await())

    /**
     * @see [getRoleAssignmentArtifact].
     * @param artifactName Name of the blueprint artifact.
     * @param blueprintName Name of the blueprint definition.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @return Blueprint artifact that applies a Role assignment.
     */
    public suspend fun getRoleAssignmentArtifact(
        artifactName: String,
        blueprintName: String,
        resourceScope: String,
    ): GetRoleAssignmentArtifactResult {
        val argument = GetRoleAssignmentArtifactPlainArgs(
            artifactName = artifactName,
            blueprintName = blueprintName,
            resourceScope = resourceScope,
        )
        return getRoleAssignmentArtifactResultToKotlin(getRoleAssignmentArtifactPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoleAssignmentArtifact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetRoleAssignmentArtifactPlainArgs].
     * @return Blueprint artifact that applies a Role assignment.
     */
    public suspend
    fun getRoleAssignmentArtifact(argument: suspend GetRoleAssignmentArtifactPlainArgsBuilder.() -> Unit):
        GetRoleAssignmentArtifactResult {
        val builder = GetRoleAssignmentArtifactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleAssignmentArtifactResultToKotlin(getRoleAssignmentArtifactPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a blueprint artifact.
     * Azure REST API version: 2018-11-01-preview.
     * @param argument null
     * @return Blueprint artifact that deploys a Resource Manager template.
     */
    public suspend fun getTemplateArtifact(argument: GetTemplateArtifactPlainArgs):
        GetTemplateArtifactResult =
        getTemplateArtifactResultToKotlin(getTemplateArtifactPlain(argument.toJava()).await())

    /**
     * @see [getTemplateArtifact].
     * @param artifactName Name of the blueprint artifact.
     * @param blueprintName Name of the blueprint definition.
     * @param resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     * @return Blueprint artifact that deploys a Resource Manager template.
     */
    public suspend fun getTemplateArtifact(
        artifactName: String,
        blueprintName: String,
        resourceScope: String,
    ): GetTemplateArtifactResult {
        val argument = GetTemplateArtifactPlainArgs(
            artifactName = artifactName,
            blueprintName = blueprintName,
            resourceScope = resourceScope,
        )
        return getTemplateArtifactResultToKotlin(getTemplateArtifactPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplateArtifact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;blueprint&#46;kotlin&#46;inputs&#46;GetTemplateArtifactPlainArgs].
     * @return Blueprint artifact that deploys a Resource Manager template.
     */
    public suspend
    fun getTemplateArtifact(argument: suspend GetTemplateArtifactPlainArgsBuilder.() -> Unit):
        GetTemplateArtifactResult {
        val builder = GetTemplateArtifactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplateArtifactResultToKotlin(getTemplateArtifactPlain(builtArgument.toJava()).await())
    }
}
