@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PolicyAssignmentArtifact].
 */
@PulumiTagMarker
public class PolicyAssignmentArtifactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAssignmentArtifactArgs = PolicyAssignmentArtifactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAssignmentArtifactArgsBuilder.() -> Unit) {
        val builder = PolicyAssignmentArtifactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyAssignmentArtifact {
        val builtJavaResource =
            com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyAssignmentArtifact(builtJavaResource)
    }
}

/**
 * Blueprint artifact that applies a Policy assignment.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "force costCenter tag on all resources",
 *         Kind = "policyAssignment",
 *         Parameters =
 *         {
 *             { "tagName", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "costCenter",
 *             } },
 *             { "tagValue", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameter('costCenter')]",
 *             } },
 *         },
 *         PolicyDefinitionId = "/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			DisplayName:   pulumi.String("force costCenter tag on all resources"),
 * 			Kind:          pulumi.String("policyAssignment"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"tagName": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("costCenter"),
 * 				},
 * 				"tagValue": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameter('costCenter')]"),
 * 				},
 * 			},
 * 			PolicyDefinitionId: pulumi.String("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62"),
 * 			ResourceScope:      pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("force costCenter tag on all resources")
 *             .kind("policyAssignment")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("tagName", Map.of("value", "costCenter")),
 *                 Map.entry("tagValue", Map.of("value", "[parameter('costCenter')]"))
 *             ))
 *             .policyDefinitionId("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         DisplayName = "force costCenter tag on all resources",
 *         Kind = "policyAssignment",
 *         Parameters =
 *         {
 *             { "tagName", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "costCenter",
 *             } },
 *             { "tagValue", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameter('costCenter')]",
 *             } },
 *         },
 *         PolicyDefinitionId = "/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			DisplayName:   pulumi.String("force costCenter tag on all resources"),
 * 			Kind:          pulumi.String("policyAssignment"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"tagName": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("costCenter"),
 * 				},
 * 				"tagValue": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameter('costCenter')]"),
 * 				},
 * 			},
 * 			PolicyDefinitionId: pulumi.String("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62"),
 * 			ResourceScope:      pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .displayName("force costCenter tag on all resources")
 *             .kind("policyAssignment")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("tagName", Map.of("value", "costCenter")),
 *                 Map.entry("tagValue", Map.of("value", "[parameter('costCenter')]"))
 *             ))
 *             .policyDefinitionId("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignmentArtifact = new AzureNative.Blueprint.PolicyAssignmentArtifact("policyAssignmentArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPolicyAssignmentArtifact(ctx, "policyAssignmentArtifact", &blueprint.PolicyAssignmentArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact;
 * import com.pulumi.azurenative.blueprint.PolicyAssignmentArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignmentArtifact = new PolicyAssignmentArtifact("policyAssignmentArtifact", PolicyAssignmentArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:PolicyAssignmentArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 */
public class PolicyAssignmentArtifact internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact,
) : KotlinCustomResource(javaResource, PolicyAssignmentArtifactMapper) {
    /**
     * Artifacts which need to be deployed before the specified artifact.
     */
    public val dependsOn: Output<List<String>>?
        get() = javaResource.dependsOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the kind of blueprint artifact.
     * Expected value is 'policyAssignment'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Parameter values for the policy definition.
     */
    public val parameters: Output<Map<String, ParameterValueResponse>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * Azure resource ID of the policy definition.
     */
    public val policyDefinitionId: Output<String>
        get() = javaResource.policyDefinitionId().applyValue({ args0 -> args0 })

    /**
     * Name of the resource group placeholder to which the policy will be assigned.
     */
    public val resourceGroup: Output<String>?
        get() = javaResource.resourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyAssignmentArtifactMapper : ResourceMapper<PolicyAssignmentArtifact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAssignmentArtifact =
        PolicyAssignmentArtifact(
            javaResource as
                com.pulumi.azurenative.blueprint.PolicyAssignmentArtifact,
        )
}

/**
 * @see [PolicyAssignmentArtifact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAssignmentArtifact].
 */
public suspend fun policyAssignmentArtifact(
    name: String,
    block: suspend PolicyAssignmentArtifactResourceBuilder.() -> Unit,
): PolicyAssignmentArtifact {
    val builder = PolicyAssignmentArtifactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAssignmentArtifact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAssignmentArtifact(name: String): PolicyAssignmentArtifact {
    val builder = PolicyAssignmentArtifactResourceBuilder()
    builder.name(name)
    return builder.build()
}
