@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse.Companion.toKotlin as blueprintStatusResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin as parameterDefinitionResponseToKotlin
import com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse.Companion.toKotlin as resourceGroupDefinitionResponseToKotlin

/**
 * Builder for [PublishedBlueprint].
 */
@PulumiTagMarker
public class PublishedBlueprintResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublishedBlueprintArgs = PublishedBlueprintArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublishedBlueprintArgsBuilder.() -> Unit) {
        val builder = PublishedBlueprintArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PublishedBlueprint {
        val builtJavaResource =
            com.pulumi.azurenative.blueprint.PublishedBlueprint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PublishedBlueprint(builtJavaResource)
    }
}

/**
 * Represents a published blueprint.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### PublishedManagementGroupBlueprint_Publish
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publishedBlueprint = new AzureNative.Blueprint.PublishedBlueprint("publishedBlueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         VersionId = "v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPublishedBlueprint(ctx, "publishedBlueprint", &blueprint.PublishedBlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			VersionId:     pulumi.String("v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprint;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publishedBlueprint = new PublishedBlueprint("publishedBlueprint", PublishedBlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .versionId("v2")
 *             .build());
 *     }
 * }
 * ```
 * ### PublishedSubscriptionBlueprint_Publish
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publishedBlueprint = new AzureNative.Blueprint.PublishedBlueprint("publishedBlueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         VersionId = "v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewPublishedBlueprint(ctx, "publishedBlueprint", &blueprint.PublishedBlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			VersionId:     pulumi.String("v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprint;
 * import com.pulumi.azurenative.blueprint.PublishedBlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publishedBlueprint = new PublishedBlueprint("publishedBlueprint", PublishedBlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .versionId("v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:PublishedBlueprint v2 /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/versions/{versionId}
 * ```
 */
public class PublishedBlueprint internal constructor(
    override val javaResource: com.pulumi.azurenative.blueprint.PublishedBlueprint,
) : KotlinCustomResource(javaResource, PublishedBlueprintMapper) {
    /**
     * Name of the published blueprint definition.
     */
    public val blueprintName: Output<String>?
        get() = javaResource.blueprintName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version-specific change notes.
     */
    public val changeNotes: Output<String>?
        get() = javaResource.changeNotes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multi-line explain this resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One-liner string explain this resource.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Parameters required by this blueprint definition.
     */
    public val parameters: Output<Map<String, ParameterDefinitionResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource group placeholders defined by this blueprint definition.
     */
    public val resourceGroups: Output<Map<String, ResourceGroupDefinitionResponse>>?
        get() = javaResource.resourceGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            resourceGroupDefinitionResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Status of the blueprint. This field is readonly.
     */
    public val status: Output<BlueprintStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                blueprintStatusResponseToKotlin(args0)
            })
        })

    /**
     * The scope where this blueprint definition can be assigned.
     */
    public val targetScope: Output<String>?
        get() = javaResource.targetScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PublishedBlueprintMapper : ResourceMapper<PublishedBlueprint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blueprint.PublishedBlueprint::class == javaResource::class

    override fun map(javaResource: Resource): PublishedBlueprint = PublishedBlueprint(
        javaResource as
            com.pulumi.azurenative.blueprint.PublishedBlueprint,
    )
}

/**
 * @see [PublishedBlueprint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PublishedBlueprint].
 */
public suspend fun publishedBlueprint(
    name: String,
    block: suspend PublishedBlueprintResourceBuilder.() -> Unit,
): PublishedBlueprint {
    val builder = PublishedBlueprintResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PublishedBlueprint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publishedBlueprint(name: String): PublishedBlueprint {
    val builder = PublishedBlueprintResourceBuilder()
    builder.name(name)
    return builder.build()
}
