@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.TemplateArtifactArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Blueprint artifact that deploys a Resource Manager template.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * ## Example Usage
 * ### MG-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         Kind = "template",
 *         Parameters =
 *         {
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameters('storageAccountType')]",
 *             } },
 *         },
 *         ResourceGroup = "storageRG",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         Template =
 *         {
 *             { "contentVersion", "1.0.0.0" },
 *             { "outputs",
 *             {
 *                 { "storageAccountName",
 *                 {
 *                     { "type", "string" },
 *                     { "value", "[variables('storageAccountName')]" },
 *                 } },
 *             } },
 *             { "parameters",
 *             {
 *                 { "storageAccountType",
 *                 {
 *                     { "allowedValues", new[]
 *                     {
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS",
 *                     } },
 *                     { "defaultValue", "Standard_LRS" },
 *                     { "metadata",
 *                     {
 *                         { "description", "Storage Account type" },
 *                     } },
 *                     { "type", "string" },
 *                 } },
 *             } },
 *             { "resources", new[]
 *             {
 *                 {
 *                     { "apiVersion", "2016-01-01" },
 *                     { "kind", "Storage" },
 *                     { "location", "[resourceGroup().location]" },
 *                     { "name", "[variables('storageAccountName')]" },
 *                     { "properties", null },
 *                     { "sku",
 *                     {
 *                         { "name", "[parameters('storageAccountType')]" },
 *                     } },
 *                     { "type", "Microsoft.Storage/storageAccounts" },
 *                 },
 *             } },
 *             { "variables",
 *             {
 *                 { "storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]" },
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Kind:          pulumi.String("template"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameters('storageAccountType')]"),
 * 				},
 * 			},
 * 			ResourceGroup: pulumi.String("storageRG"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			Template: pulumi.Any{
 * 				ContentVersion: "1.0.0.0",
 * 				Outputs: map[string]interface{}{
 * 					"storageAccountName": map[string]interface{}{
 * 						"type":  "string",
 * 						"value": "[variables('storageAccountName')]",
 * 					},
 * 				},
 * 				Parameters: map[string]interface{}{
 * 					"storageAccountType": map[string]interface{}{
 * 						"allowedValues": []string{
 * 							"Standard_LRS",
 * 							"Standard_GRS",
 * 							"Standard_ZRS",
 * 							"Premium_LRS",
 * 						},
 * 						"defaultValue": "Standard_LRS",
 * 						"metadata": map[string]interface{}{
 * 							"description": "Storage Account type",
 * 						},
 * 						"type": "string",
 * 					},
 * 				},
 * 				Resources: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2016-01-01",
 * 						"kind":       "Storage",
 * 						"location":   "[resourceGroup().location]",
 * 						"name":       "[variables('storageAccountName')]",
 * 						"properties": nil,
 * 						"sku": map[string]interface{}{
 * 							"name": "[parameters('storageAccountType')]",
 * 						},
 * 						"type": "Microsoft.Storage/storageAccounts",
 * 					},
 * 				},
 * 				Variables: map[string]interface{}{
 * 					"storageAccountName": "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .kind("template")
 *             .parameters(Map.of("storageAccountType", Map.of("value", "[parameters('storageAccountType')]")))
 *             .resourceGroup("storageRG")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .template(Map.ofEntries(
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", Map.of("storageAccountName", Map.ofEntries(
 *                     Map.entry("type", "string"),
 *                     Map.entry("value", "[variables('storageAccountName')]")
 *                 ))),
 *                 Map.entry("parameters", Map.of("storageAccountType", Map.ofEntries(
 *                     Map.entry("allowedValues",
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS"),
 *                     Map.entry("defaultValue", "Standard_LRS"),
 *                     Map.entry("metadata", Map.of("description", "Storage Account type")),
 *                     Map.entry("type", "string")
 *                 ))),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("apiVersion", "2016-01-01"),
 *                     Map.entry("kind", "Storage"),
 *                     Map.entry("location", "[resourceGroup().location]"),
 *                     Map.entry("name", "[variables('storageAccountName')]"),
 *                     Map.entry("properties", ),
 *                     Map.entry("sku", Map.of("name", "[parameters('storageAccountType')]")),
 *                     Map.entry("type", "Microsoft.Storage/storageAccounts")
 *                 )),
 *                 Map.entry("variables", Map.of("storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### MG-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### MG-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-ARMTemplateArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "storageTemplate",
 *         BlueprintName = "simpleBlueprint",
 *         Kind = "template",
 *         Parameters =
 *         {
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterValueArgs
 *             {
 *                 Value = "[parameters('storageAccountType')]",
 *             } },
 *         },
 *         ResourceGroup = "storageRG",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Template =
 *         {
 *             { "contentVersion", "1.0.0.0" },
 *             { "outputs",
 *             {
 *                 { "storageAccountName",
 *                 {
 *                     { "type", "string" },
 *                     { "value", "[variables('storageAccountName')]" },
 *                 } },
 *             } },
 *             { "parameters",
 *             {
 *                 { "storageAccountType",
 *                 {
 *                     { "allowedValues", new[]
 *                     {
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS",
 *                     } },
 *                     { "defaultValue", "Standard_LRS" },
 *                     { "metadata",
 *                     {
 *                         { "description", "Storage Account type" },
 *                     } },
 *                     { "type", "string" },
 *                 } },
 *             } },
 *             { "resources", new[]
 *             {
 *                 {
 *                     { "apiVersion", "2016-01-01" },
 *                     { "kind", "Storage" },
 *                     { "location", "[resourceGroup().location]" },
 *                     { "name", "[variables('storageAccountName')]" },
 *                     { "properties", null },
 *                     { "sku",
 *                     {
 *                         { "name", "[parameters('storageAccountType')]" },
 *                     } },
 *                     { "type", "Microsoft.Storage/storageAccounts" },
 *                 },
 *             } },
 *             { "variables",
 *             {
 *                 { "storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]" },
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("storageTemplate"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Kind:          pulumi.String("template"),
 * 			Parameters: blueprint.ParameterValueMap{
 * 				"storageAccountType": &blueprint.ParameterValueArgs{
 * 					Value: pulumi.Any("[parameters('storageAccountType')]"),
 * 				},
 * 			},
 * 			ResourceGroup: pulumi.String("storageRG"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Template: pulumi.Any{
 * 				ContentVersion: "1.0.0.0",
 * 				Outputs: map[string]interface{}{
 * 					"storageAccountName": map[string]interface{}{
 * 						"type":  "string",
 * 						"value": "[variables('storageAccountName')]",
 * 					},
 * 				},
 * 				Parameters: map[string]interface{}{
 * 					"storageAccountType": map[string]interface{}{
 * 						"allowedValues": []string{
 * 							"Standard_LRS",
 * 							"Standard_GRS",
 * 							"Standard_ZRS",
 * 							"Premium_LRS",
 * 						},
 * 						"defaultValue": "Standard_LRS",
 * 						"metadata": map[string]interface{}{
 * 							"description": "Storage Account type",
 * 						},
 * 						"type": "string",
 * 					},
 * 				},
 * 				Resources: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"apiVersion": "2016-01-01",
 * 						"kind":       "Storage",
 * 						"location":   "[resourceGroup().location]",
 * 						"name":       "[variables('storageAccountName')]",
 * 						"properties": nil,
 * 						"sku": map[string]interface{}{
 * 							"name": "[parameters('storageAccountType')]",
 * 						},
 * 						"type": "Microsoft.Storage/storageAccounts",
 * 					},
 * 				},
 * 				Variables: map[string]interface{}{
 * 					"storageAccountName": "[concat(uniquestring(resourceGroup().id), 'standardsa')]",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("storageTemplate")
 *             .blueprintName("simpleBlueprint")
 *             .kind("template")
 *             .parameters(Map.of("storageAccountType", Map.of("value", "[parameters('storageAccountType')]")))
 *             .resourceGroup("storageRG")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .template(Map.ofEntries(
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", Map.of("storageAccountName", Map.ofEntries(
 *                     Map.entry("type", "string"),
 *                     Map.entry("value", "[variables('storageAccountName')]")
 *                 ))),
 *                 Map.entry("parameters", Map.of("storageAccountType", Map.ofEntries(
 *                     Map.entry("allowedValues",
 *                         "Standard_LRS",
 *                         "Standard_GRS",
 *                         "Standard_ZRS",
 *                         "Premium_LRS"),
 *                     Map.entry("defaultValue", "Standard_LRS"),
 *                     Map.entry("metadata", Map.of("description", "Storage Account type")),
 *                     Map.entry("type", "string")
 *                 ))),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("apiVersion", "2016-01-01"),
 *                     Map.entry("kind", "Storage"),
 *                     Map.entry("location", "[resourceGroup().location]"),
 *                     Map.entry("name", "[variables('storageAccountName')]"),
 *                     Map.entry("properties", ),
 *                     Map.entry("sku", Map.of("name", "[parameters('storageAccountType')]")),
 *                     Map.entry("type", "Microsoft.Storage/storageAccounts")
 *                 )),
 *                 Map.entry("variables", Map.of("storageAccountName", "[concat(uniquestring(resourceGroup().id), 'standardsa')]"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-PolicyAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "costCenterPolicy",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("costCenterPolicy"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("costCenterPolicy")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ### Sub-RoleAssignmentArtifact
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateArtifact = new AzureNative.Blueprint.TemplateArtifact("templateArtifact", new()
 *     {
 *         ArtifactName = "ownerAssignment",
 *         BlueprintName = "simpleBlueprint",
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewTemplateArtifact(ctx, "templateArtifact", &blueprint.TemplateArtifactArgs{
 * 			ArtifactName:  pulumi.String("ownerAssignment"),
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.TemplateArtifact;
 * import com.pulumi.azurenative.blueprint.TemplateArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateArtifact = new TemplateArtifact("templateArtifact", TemplateArtifactArgs.builder()
 *             .artifactName("ownerAssignment")
 *             .blueprintName("simpleBlueprint")
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:TemplateArtifact ownerAssignment /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}
 * ```
 * @property artifactName Name of the blueprint artifact.
 * @property blueprintName Name of the blueprint definition.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'template'.
 * @property parameters Resource Manager template blueprint artifact parameter values.
 * @property resourceGroup If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property template The Resource Manager template blueprint artifact body.
 */
public data class TemplateArtifactArgs(
    public val artifactName: Output<String>? = null,
    public val blueprintName: Output<String>? = null,
    public val dependsOn: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterValueArgs>>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceScope: Output<String>? = null,
    public val template: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.TemplateArtifactArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.TemplateArtifactArgs =
        com.pulumi.azurenative.blueprint.TemplateArtifactArgs.builder()
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .blueprintName(blueprintName?.applyValue({ args0 -> args0 }))
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 }))
            .template(template?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArtifactArgs].
 */
@PulumiTagMarker
public class TemplateArtifactArgsBuilder internal constructor() {
    private var artifactName: Output<String>? = null

    private var blueprintName: Output<String>? = null

    private var dependsOn: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var parameters: Output<Map<String, ParameterValueArgs>>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceScope: Output<String>? = null

    private var template: Output<Any>? = null

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("updqjtljnemkdruj")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("cyxvneamxbysgrnh")
    public suspend fun blueprintName(`value`: Output<String>) {
        this.blueprintName = value
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("xxjgykvryrmwvooy")
    public suspend fun dependsOn(`value`: Output<List<String>>) {
        this.dependsOn = value
    }

    @JvmName("pwsutxuxlfysvayl")
    public suspend fun dependsOn(vararg values: Output<String>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("yqvbshelmbpttimt")
    public suspend fun dependsOn(values: List<Output<String>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("ahcexujdlkkxvmch")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("wsqjcuwuosxiymxy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'template'.
     */
    @JvmName("oikdpmgkmyftftso")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Manager template blueprint artifact parameter values.
     */
    @JvmName("dlwghujixmmonksw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
     */
    @JvmName("tyholdmfkbhamxat")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("gkphldfyspgfnggq")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value The Resource Manager template blueprint artifact body.
     */
    @JvmName("pmecasrtyqktnooi")
    public suspend fun template(`value`: Output<Any>) {
        this.template = value
    }

    /**
     * @param value Name of the blueprint artifact.
     */
    @JvmName("tkgloperfvrusuch")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("qmkhrsvtcoqgvdup")
    public suspend fun blueprintName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintName = mapped
    }

    /**
     * @param value Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("xcoymbalnvjlwvjt")
    public suspend fun dependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Artifacts which need to be deployed before the specified artifact.
     */
    @JvmName("htmnlitcocdjnkeu")
    public suspend fun dependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("xcrgbaaawjrsowjm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("qunkhdookxdnjedr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Specifies the kind of blueprint artifact.
     * Expected value is 'template'.
     */
    @JvmName("pfvtimgpgfvqntgi")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Manager template blueprint artifact parameter values.
     */
    @JvmName("fjlycffmnquillad")
    public suspend fun parameters(`value`: Map<String, ParameterValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Resource Manager template blueprint artifact parameter values.
     */
    @JvmName("vfefseaedspfwrbu")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Resource Manager template blueprint artifact parameter values.
     */
    @JvmName("kruoelvidwtowvru")
    public fun parameters(vararg values: Pair<String, ParameterValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
     */
    @JvmName("sgnoopoavwpgbkde")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("cfmstymeycctogpf")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    /**
     * @param value The Resource Manager template blueprint artifact body.
     */
    @JvmName("spwoawjxyqdxtonr")
    public suspend fun template(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    internal fun build(): TemplateArtifactArgs = TemplateArtifactArgs(
        artifactName = artifactName,
        blueprintName = blueprintName,
        dependsOn = dependsOn,
        description = description,
        displayName = displayName,
        kind = kind,
        parameters = parameters,
        resourceGroup = resourceGroup,
        resourceScope = resourceScope,
        template = template,
    )
}
