@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The scope where this blueprint definition can be assigned.
 */
public enum class BlueprintTargetScope(
    public val javaValue: com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope> {
    /**
     * The blueprint targets a subscription during blueprint assignment.
     */
    Subscription(com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope.Subscription),

    /**
     * The blueprint targets a management group during blueprint assignment. This is reserved for future use.
     */
    ManagementGroup(com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope.ManagementGroup),
    ;

    override fun toJava(): com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.enums.BlueprintTargetScope):
            BlueprintTargetScope = BlueprintTargetScope.values().first { it.javaValue == javaType }
    }
}
