@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.ParameterDefinitionArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.enums.TemplateParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represent a parameter with constrains and metadata.
 * @property allowedValues Array of allowed values for this parameter.
 * @property defaultValue Default Value for this parameter.
 * @property description Description of this parameter/resourceGroup.
 * @property displayName DisplayName of this parameter/resourceGroup.
 * @property strongType StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
 * @property type Allowed data types for Resource Manager template parameters.
 */
public data class ParameterDefinitionArgs(
    public val allowedValues: Output<List<Any>>? = null,
    public val defaultValue: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val strongType: Output<String>? = null,
    public val type: Output<Either<String, TemplateParameterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.ParameterDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.ParameterDefinitionArgs =
        com.pulumi.azurenative.blueprint.inputs.ParameterDefinitionArgs.builder()
            .allowedValues(allowedValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .strongType(strongType?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterDefinitionArgs].
 */
@PulumiTagMarker
public class ParameterDefinitionArgsBuilder internal constructor() {
    private var allowedValues: Output<List<Any>>? = null

    private var defaultValue: Output<Any>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var strongType: Output<String>? = null

    private var type: Output<Either<String, TemplateParameterType>>? = null

    /**
     * @param value Array of allowed values for this parameter.
     */
    @JvmName("llvjoxsepopfdbti")
    public suspend fun allowedValues(`value`: Output<List<Any>>) {
        this.allowedValues = value
    }

    @JvmName("sxesgsgwbfeucfmr")
    public suspend fun allowedValues(vararg values: Output<Any>) {
        this.allowedValues = Output.all(values.asList())
    }

    /**
     * @param values Array of allowed values for this parameter.
     */
    @JvmName("nqgpjubdrfrptaqr")
    public suspend fun allowedValues(values: List<Output<Any>>) {
        this.allowedValues = Output.all(values)
    }

    /**
     * @param value Default Value for this parameter.
     */
    @JvmName("fwkfnmuwewhhvlgq")
    public suspend fun defaultValue(`value`: Output<Any>) {
        this.defaultValue = value
    }

    /**
     * @param value Description of this parameter/resourceGroup.
     */
    @JvmName("owneuoxukgydygyk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value DisplayName of this parameter/resourceGroup.
     */
    @JvmName("dsrbeipvhxaoquin")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
     */
    @JvmName("dhkgayooebssehdh")
    public suspend fun strongType(`value`: Output<String>) {
        this.strongType = value
    }

    /**
     * @param value Allowed data types for Resource Manager template parameters.
     */
    @JvmName("kcybyijxpjgubkjo")
    public suspend fun type(`value`: Output<Either<String, TemplateParameterType>>) {
        this.type = value
    }

    /**
     * @param value Array of allowed values for this parameter.
     */
    @JvmName("gfwjoglvrriawotl")
    public suspend fun allowedValues(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedValues = mapped
    }

    /**
     * @param values Array of allowed values for this parameter.
     */
    @JvmName("ummanvdopcgrmhae")
    public suspend fun allowedValues(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedValues = mapped
    }

    /**
     * @param value Default Value for this parameter.
     */
    @JvmName("kfnobbyxsqvkubnw")
    public suspend fun defaultValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Description of this parameter/resourceGroup.
     */
    @JvmName("twnxcpenulhirvju")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value DisplayName of this parameter/resourceGroup.
     */
    @JvmName("mtjalhlkesmxxxgc")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
     */
    @JvmName("lqbgirgscucfkeks")
    public suspend fun strongType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strongType = mapped
    }

    /**
     * @param value Allowed data types for Resource Manager template parameters.
     */
    @JvmName("oapqddasujqvtwft")
    public suspend fun type(`value`: Either<String, TemplateParameterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Allowed data types for Resource Manager template parameters.
     */
    @JvmName("njhwovvoyejidtmm")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TemplateParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Allowed data types for Resource Manager template parameters.
     */
    @JvmName("bmmklbtuvxbuvsle")
    public fun type(`value`: TemplateParameterType) {
        val toBeMapped = Either.ofRight<String, TemplateParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParameterDefinitionArgs = ParameterDefinitionArgs(
        allowedValues = allowedValues,
        defaultValue = defaultValue,
        description = description,
        displayName = displayName,
        strongType = strongType,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
