@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.ResourceGroupDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an Azure resource group in a blueprint definition.
 * @property dependsOn Artifacts which need to be deployed before this resource group.
 * @property description Description of this parameter/resourceGroup.
 * @property displayName DisplayName of this parameter/resourceGroup.
 * @property location Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
 * @property name Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
 * @property strongType StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
 * @property tags Tags to be assigned to this resource group.
 */
public data class ResourceGroupDefinitionArgs(
    public val dependsOn: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val strongType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.ResourceGroupDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.ResourceGroupDefinitionArgs =
        com.pulumi.azurenative.blueprint.inputs.ResourceGroupDefinitionArgs.builder()
            .dependsOn(dependsOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .strongType(strongType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGroupDefinitionArgs].
 */
@PulumiTagMarker
public class ResourceGroupDefinitionArgsBuilder internal constructor() {
    private var dependsOn: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var strongType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Artifacts which need to be deployed before this resource group.
     */
    @JvmName("xwlwwdqonfhkfqqf")
    public suspend fun dependsOn(`value`: Output<List<String>>) {
        this.dependsOn = value
    }

    @JvmName("cjxciaudgepvfamb")
    public suspend fun dependsOn(vararg values: Output<String>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Artifacts which need to be deployed before this resource group.
     */
    @JvmName("ysmfmvqcbuliocjs")
    public suspend fun dependsOn(values: List<Output<String>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Description of this parameter/resourceGroup.
     */
    @JvmName("igbkhfubvcmpcuvk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value DisplayName of this parameter/resourceGroup.
     */
    @JvmName("mlpiaqsqxejypvhb")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
     */
    @JvmName("tsphircysdleccnj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
     */
    @JvmName("lakygisjrwldcnop")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
     */
    @JvmName("waprqnpxwfmgucvu")
    public suspend fun strongType(`value`: Output<String>) {
        this.strongType = value
    }

    /**
     * @param value Tags to be assigned to this resource group.
     */
    @JvmName("xemthjrqhwvqxcug")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Artifacts which need to be deployed before this resource group.
     */
    @JvmName("sdmuykistqgttnhs")
    public suspend fun dependsOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param values Artifacts which need to be deployed before this resource group.
     */
    @JvmName("urotrckejpsygslb")
    public suspend fun dependsOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Description of this parameter/resourceGroup.
     */
    @JvmName("ybkyqtivaglifswj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value DisplayName of this parameter/resourceGroup.
     */
    @JvmName("cadbqnfxujqsyvlg")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
     */
    @JvmName("cdckrbtnlyfloimi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
     */
    @JvmName("mejooquxfsttfsga")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
     */
    @JvmName("lwdlkttcgtibnjwo")
    public suspend fun strongType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strongType = mapped
    }

    /**
     * @param value Tags to be assigned to this resource group.
     */
    @JvmName("rgvbqsgxmvddgeok")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to be assigned to this resource group.
     */
    @JvmName("gdtribghomgyhshi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGroupDefinitionArgs = ResourceGroupDefinitionArgs(
        dependsOn = dependsOn,
        description = description,
        displayName = displayName,
        location = location,
        name = name,
        strongType = strongType,
        tags = tags,
    )
}
