@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.inputs

import com.pulumi.azurenative.blueprint.inputs.UserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User-assigned managed identity.
 * @property clientId Client App Id associated with this identity.
 * @property principalId Azure Active Directory principal ID associated with this Identity.
 */
public data class UserAssignedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.inputs.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.inputs.UserAssignedIdentityArgs =
        com.pulumi.azurenative.blueprint.inputs.UserAssignedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value Client App Id associated with this identity.
     */
    @JvmName("oqgkbcmhwnmdhvph")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Azure Active Directory principal ID associated with this Identity.
     */
    @JvmName("aookstanemawmtvs")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Client App Id associated with this identity.
     */
    @JvmName("vwjkrtncglvedfhb")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Azure Active Directory principal ID associated with this Identity.
     */
    @JvmName("sgydtmiibhjqhfxr")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        clientId = clientId,
        principalId = principalId,
    )
}
