@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of the blueprint. This field is readonly.
 * @property lastModified Last modified time of this blueprint definition.
 * @property timeCreated Creation time of this blueprint definition.
 */
public data class BlueprintStatusResponse(
    public val lastModified: String,
    public val timeCreated: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.BlueprintStatusResponse):
            BlueprintStatusResponse = BlueprintStatusResponse(
            lastModified = javaType.lastModified(),
            timeCreated = javaType.timeCreated(),
        )
    }
}
