@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a Blueprint definition.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property layout Layout view of the blueprint definition for UI reference.
 * @property name Name of this resource.
 * @property parameters Parameters required by this blueprint definition.
 * @property resourceGroups Resource group placeholders defined by this blueprint definition.
 * @property status Status of the blueprint. This field is readonly.
 * @property targetScope The scope where this blueprint definition can be assigned.
 * @property type Type of this resource.
 * @property versions Published versions of this blueprint definition.
 */
public data class GetBlueprintResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val layout: Any,
    public val name: String,
    public val parameters: Map<String, ParameterDefinitionResponse>? = null,
    public val resourceGroups: Map<String, ResourceGroupDefinitionResponse>? = null,
    public val status: BlueprintStatusResponse,
    public val targetScope: String,
    public val type: String,
    public val versions: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetBlueprintResult):
            GetBlueprintResult = GetBlueprintResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            layout = javaType.layout(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroups = javaType.resourceGroups().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ResourceGroupDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.blueprint.kotlin.outputs.BlueprintStatusResponse.Companion.toKotlin(args0)
            }),
            targetScope = javaType.targetScope(),
            type = javaType.type(),
            versions = javaType.versions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
