@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Blueprint artifact that deploys a Resource Manager template.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'template'.
 * @property name Name of this resource.
 * @property parameters Resource Manager template blueprint artifact parameter values.
 * @property resourceGroup If applicable, the name of the resource group placeholder to which the Resource Manager template blueprint artifact will be deployed.
 * @property template The Resource Manager template blueprint artifact body.
 * @property type Type of this resource.
 */
public data class GetTemplateArtifactResult(
    public val dependsOn: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val parameters: Map<String, ParameterValueResponse>,
    public val resourceGroup: String? = null,
    public val template: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetTemplateArtifactResult):
            GetTemplateArtifactResult = GetTemplateArtifactResult(
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.blueprint.kotlin.outputs.ParameterValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            template = javaType.template(),
            type = javaType.type(),
        )
    }
}
