@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an Azure resource group.
 * @property location Location of the resource group.
 * @property name Name of the resource group.
 */
public data class ResourceGroupValueResponse(
    public val location: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.ResourceGroupValueResponse):
            ResourceGroupValueResponse = ResourceGroupValueResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
