@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.BotConnectionArgs.builder
import com.pulumi.azurenative.botservice.kotlin.enums.Kind
import com.pulumi.azurenative.botservice.kotlin.inputs.ConnectionSettingPropertiesArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.ConnectionSettingPropertiesArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Bot channel resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Connection Setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var botConnection = new AzureNative.BotService.BotConnection("botConnection", new()
 *     {
 *         ConnectionName = "sampleConnection",
 *         Location = "West US",
 *         Properties = new AzureNative.BotService.Inputs.ConnectionSettingPropertiesArgs
 *         {
 *             ClientId = "sampleclientid",
 *             ClientSecret = "samplesecret",
 *             Parameters = new[]
 *             {
 *                 new AzureNative.BotService.Inputs.ConnectionSettingParameterArgs
 *                 {
 *                     Key = "key1",
 *                     Value = "value1",
 *                 },
 *                 new AzureNative.BotService.Inputs.ConnectionSettingParameterArgs
 *                 {
 *                     Key = "key2",
 *                     Value = "value2",
 *                 },
 *             },
 *             Scopes = "samplescope",
 *             ServiceProviderId = "serviceproviderid",
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewBotConnection(ctx, "botConnection", &botservice.BotConnectionArgs{
 * 			ConnectionName: pulumi.String("sampleConnection"),
 * 			Location:       pulumi.String("West US"),
 * 			Properties: botservice.ConnectionSettingPropertiesResponse{
 * 				ClientId:     pulumi.String("sampleclientid"),
 * 				ClientSecret: pulumi.String("samplesecret"),
 * 				Parameters: botservice.ConnectionSettingParameterArray{
 * 					&botservice.ConnectionSettingParameterArgs{
 * 						Key:   pulumi.String("key1"),
 * 						Value: pulumi.String("value1"),
 * 					},
 * 					&botservice.ConnectionSettingParameterArgs{
 * 						Key:   pulumi.String("key2"),
 * 						Value: pulumi.String("value2"),
 * 					},
 * 				},
 * 				Scopes:            pulumi.String("samplescope"),
 * 				ServiceProviderId: pulumi.String("serviceproviderid"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.BotConnection;
 * import com.pulumi.azurenative.botservice.BotConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var botConnection = new BotConnection("botConnection", BotConnectionArgs.builder()
 *             .connectionName("sampleConnection")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("clientId", "sampleclientid"),
 *                 Map.entry("clientSecret", "samplesecret"),
 *                 Map.entry("parameters",
 *                     Map.ofEntries(
 *                         Map.entry("key", "key1"),
 *                         Map.entry("value", "value1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("key", "key2"),
 *                         Map.entry("value", "value2")
 *                     )),
 *                 Map.entry("scopes", "samplescope"),
 *                 Map.entry("serviceProviderId", "serviceproviderid")
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:BotConnection sampleConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/connections/{connectionName}
 * ```
 * @property connectionName The name of the Bot Service Connection Setting resource.
 * @property kind Required. Gets or sets the Kind of the resource.
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to bot channel resource
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property resourceName The name of the Bot resource.
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 */
public data class BotConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConnectionSettingPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.BotConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.BotConnectionArgs =
        com.pulumi.azurenative.botservice.BotConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BotConnectionArgs].
 */
@PulumiTagMarker
public class BotConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConnectionSettingPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Bot Service Connection Setting resource.
     */
    @JvmName("lvsnrfmolbgqwmnn")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("salsbtomqbciggmi")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("fhelnsefddqckqyl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to bot channel resource
     */
    @JvmName("sawppgiggkbvbqhq")
    public suspend fun properties(`value`: Output<ConnectionSettingPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("uogwdtmmiibtobbt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("ebnaaukyxnjxcjif")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("yppxhtyfasjwkjpv")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("qacsjmkgkospxcxg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Bot Service Connection Setting resource.
     */
    @JvmName("xgelifrncayccchv")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("xqukhjeiqtnikcgd")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("notejrnhvcbyjpni")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("lxjlwtpdvshvwtyj")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("wfpiasrrpgttpnig")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to bot channel resource
     */
    @JvmName("qresxblrdydoqsjl")
    public suspend fun properties(`value`: ConnectionSettingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to bot channel resource
     */
    @JvmName("vxlyxixfuqwlksik")
    public suspend
    fun properties(argument: suspend ConnectionSettingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionSettingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("ydeubtefcxfdfjae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("aeprluhksfwkjalo")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("xauqdoklwylttati")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the SKU of the resource.
     */
    @JvmName("phekkxsxnpxdiptn")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("bwnafnmlwxxbjrpk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("kxmdvxlylojgwigv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BotConnectionArgs = BotConnectionArgs(
        connectionName = connectionName,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
