@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.ChannelArgs.builder
import com.pulumi.azurenative.botservice.kotlin.enums.Kind
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Bot channel resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Alexa Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "AlexaChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.AlexaChannelArgs
 *         {
 *             ChannelName = "AlexaChannel",
 *             Properties = new AzureNative.BotService.Inputs.AlexaChannelPropertiesArgs
 *             {
 *                 AlexaSkillId = "XAlexaSkillIdX",
 *                 IsEnabled = true,
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("AlexaChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.AlexaChannel{
 * 				ChannelName: "AlexaChannel",
 * 				Properties: botservice.AlexaChannelProperties{
 * 					AlexaSkillId: "XAlexaSkillIdX",
 * 					IsEnabled:    true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("AlexaChannel")
 *             .location("global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("channelName", "AlexaChannel"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("alexaSkillId", "XAlexaSkillIdX"),
 *                     Map.entry("isEnabled", true)
 *                 ))
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "EmailChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.EmailChannelArgs
 *         {
 *             ChannelName = "EmailChannel",
 *             Properties = new AzureNative.BotService.Inputs.EmailChannelPropertiesArgs
 *             {
 *                 EmailAddress = "a@b.com",
 *                 IsEnabled = true,
 *                 Password = "pwd",
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("EmailChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.EmailChannel{
 * 				ChannelName: "EmailChannel",
 * 				Properties: botservice.EmailChannelProperties{
 * 					EmailAddress: "a@b.com",
 * 					IsEnabled:    true,
 * 					Password:     "pwd",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("EmailChannel")
 *             .location("global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("channelName", "EmailChannel"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("emailAddress", "a@b.com"),
 *                     Map.entry("isEnabled", true),
 *                     Map.entry("password", "pwd")
 *                 ))
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create DirectLine Speech Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "DirectLineSpeechChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.DirectLineSpeechChannelArgs
 *         {
 *             ChannelName = "DirectLineSpeechChannel",
 *             Properties = new AzureNative.BotService.Inputs.DirectLineSpeechChannelPropertiesArgs
 *             {
 *                 CognitiveServiceRegion = "XcognitiveServiceRegionX",
 *                 CognitiveServiceSubscriptionKey = "XcognitiveServiceSubscriptionKeyX",
 *                 IsEnabled = true,
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("DirectLineSpeechChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.DirectLineSpeechChannel{
 * 				ChannelName: "DirectLineSpeechChannel",
 * 				Properties: botservice.DirectLineSpeechChannelProperties{
 * 					CognitiveServiceRegion:          "XcognitiveServiceRegionX",
 * 					CognitiveServiceSubscriptionKey: "XcognitiveServiceSubscriptionKeyX",
 * 					IsEnabled:                       true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("DirectLineSpeechChannel")
 *             .location("global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("channelName", "DirectLineSpeechChannel"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("cognitiveServiceRegion", "XcognitiveServiceRegionX"),
 *                     Map.entry("cognitiveServiceSubscriptionKey", "XcognitiveServiceSubscriptionKeyX"),
 *                     Map.entry("isEnabled", true)
 *                 ))
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Email Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "EmailChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.EmailChannelArgs
 *         {
 *             ChannelName = "EmailChannel",
 *             Properties = new AzureNative.BotService.Inputs.EmailChannelPropertiesArgs
 *             {
 *                 AuthMethod = 1,
 *                 EmailAddress = "a@b.com",
 *                 IsEnabled = true,
 *                 MagicCode = "000000",
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("EmailChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.EmailChannel{
 * 				ChannelName: "EmailChannel",
 * 				Properties: botservice.EmailChannelProperties{
 * 					AuthMethod:   1,
 * 					EmailAddress: "a@b.com",
 * 					IsEnabled:    true,
 * 					MagicCode:    "000000",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("EmailChannel")
 *             .location("global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("channelName", "EmailChannel"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("authMethod", 1),
 *                     Map.entry("emailAddress", "a@b.com"),
 *                     Map.entry("isEnabled", true),
 *                     Map.entry("magicCode", "000000")
 *                 ))
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Line Channel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.BotService.Channel("channel", new()
 *     {
 *         ChannelName = "LineChannel",
 *         Location = "global",
 *         Properties = new AzureNative.BotService.Inputs.LineChannelArgs
 *         {
 *             ChannelName = "LineChannel",
 *             Properties = new AzureNative.BotService.Inputs.LineChannelPropertiesArgs
 *             {
 *                 LineRegistrations = new[]
 *                 {
 *                     new AzureNative.BotService.Inputs.LineRegistrationArgs
 *                     {
 *                         ChannelAccessToken = "channelAccessToken",
 *                         ChannelSecret = "channelSecret",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewChannel(ctx, "channel", &botservice.ChannelArgs{
 * 			ChannelName: pulumi.String("LineChannel"),
 * 			Location:    pulumi.String("global"),
 * 			Properties: botservice.LineChannel{
 * 				ChannelName: "LineChannel",
 * 				Properties: botservice.LineChannelProperties{
 * 					LineRegistrations: []botservice.LineRegistration{
 * 						{
 * 							ChannelAccessToken: "channelAccessToken",
 * 							ChannelSecret:      "channelSecret",
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Channel;
 * import com.pulumi.azurenative.botservice.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("LineChannel")
 *             .location("global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("channelName", "LineChannel"),
 *                 Map.entry("properties", Map.of("lineRegistrations", Map.ofEntries(
 *                     Map.entry("channelAccessToken", "channelAccessToken"),
 *                     Map.entry("channelSecret", "channelSecret")
 *                 )))
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:Channel myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}
 * ```
 * @property channelName The name of the Channel resource.
 * @property kind Required. Gets or sets the Kind of the resource.
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to bot channel resource
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property resourceName The name of the Bot resource.
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 */
public data class ChannelArgs(
    public val channelName: Output<String>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.ChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.ChannelArgs =
        com.pulumi.azurenative.botservice.ChannelArgs.builder()
            .channelName(channelName?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Channel resource.
     */
    @JvmName("ybbsqlqpqeqjokek")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("qdrxgkvpexeqinlk")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("flralovhstuydnci")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to bot channel resource
     */
    @JvmName("nodpjcfvedblgcvt")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("pydwrkpvogieiolu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("vvmxiusgwsrblccu")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("qfnmgncqhcsnccki")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("jfbuuopxfhhjpxyv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Channel resource.
     */
    @JvmName("rfhyuckkotrgdlpr")
    public suspend fun channelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("miennhflleexehnk")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("evylqryatntjocty")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("fqsdcauqrccjkecp")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("wxvmigkjegxfiknh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to bot channel resource
     */
    @JvmName("rcsmjnnpvgvedfjb")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("hwytvnaixrpxluve")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("rpeodoobamfvqnkm")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("tulskojqglxsmwlu")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the SKU of the resource.
     */
    @JvmName("tblaegocgjjfqekn")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("ewobdcguxqwfgxku")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("miyxdytlnpbbbchi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        channelName = channelName,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
