@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.AlexaChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Alexa channel.
 * @property alexaSkillId The Alexa skill Id
 * @property isEnabled Whether this channel is enabled for the bot
 */
public data class AlexaChannelPropertiesArgs(
    public val alexaSkillId: Output<String>,
    public val isEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.AlexaChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.AlexaChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.AlexaChannelPropertiesArgs.builder()
            .alexaSkillId(alexaSkillId.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlexaChannelPropertiesArgs].
 */
@PulumiTagMarker
public class AlexaChannelPropertiesArgsBuilder internal constructor() {
    private var alexaSkillId: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value The Alexa skill Id
     */
    @JvmName("biniclqohtknervj")
    public suspend fun alexaSkillId(`value`: Output<String>) {
        this.alexaSkillId = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("nxouuwecodmjievi")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The Alexa skill Id
     */
    @JvmName("nmwhhtelygbfpcke")
    public suspend fun alexaSkillId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alexaSkillId = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("ucwmqrxjfmyxpjwe")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): AlexaChannelPropertiesArgs = AlexaChannelPropertiesArgs(
        alexaSkillId = alexaSkillId ?: throw PulumiNullFieldException("alexaSkillId"),
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
    )
}
